/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.channels.values;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.PositiveOrZero;
import pl.grzeslowski.jsupla.Preconditions;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;

public final class RgbValue
implements ChannelValue {
    @PositiveOrZero
    @Min(value=0L)
    @Max(value=255L)
    public final @PositiveOrZero @Min(value=0L) @Max(value=255L) int brightness;
    @PositiveOrZero
    @Min(value=0L)
    @Max(value=255L)
    public final @PositiveOrZero @Min(value=0L) @Max(value=255L) int colorBrightness;
    @PositiveOrZero
    @Min(value=0L)
    @Max(value=255L)
    public final @PositiveOrZero @Min(value=0L) @Max(value=255L) int red;
    @PositiveOrZero
    @Min(value=0L)
    @Max(value=255L)
    public final @PositiveOrZero @Min(value=0L) @Max(value=255L) int green;
    @PositiveOrZero
    @Min(value=0L)
    @Max(value=255L)
    public final @PositiveOrZero @Min(value=0L) @Max(value=255L) int blue;

    public RgbValue(int brightness, int colorBrightness, int red, int green, int blue) {
        this.brightness = Preconditions.unsignedByteSize((int)brightness);
        this.colorBrightness = Preconditions.unsignedByteSize((int)colorBrightness);
        this.red = Preconditions.unsignedByteSize((int)red);
        this.green = Preconditions.unsignedByteSize((int)green);
        this.blue = Preconditions.unsignedByteSize((int)blue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RgbValue)) {
            return false;
        }
        RgbValue rgbValue = (RgbValue)o;
        if (this.brightness != rgbValue.brightness) {
            return false;
        }
        if (this.colorBrightness != rgbValue.colorBrightness) {
            return false;
        }
        if (this.red != rgbValue.red) {
            return false;
        }
        if (this.green != rgbValue.green) {
            return false;
        }
        return this.blue == rgbValue.blue;
    }

    public final int hashCode() {
        int result = this.brightness;
        result = 31 * result + this.colorBrightness;
        result = 31 * result + this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        return result;
    }

    public String toString() {
        return "RgbValue{brightness=" + this.brightness + ", colorBrightness=" + this.colorBrightness + ", R=" + this.red + ", G=" + this.green + ", B=" + this.blue + '}';
    }
}

