/*
 * Decompiled with CFR 0.152.
 */
package pl.grzeslowski.jsupla.protocoljava.api.channels.values;

import java.util.Objects;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.ChannelValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.DecimalValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.OnOff;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.OpenClose;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.PercentValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.RgbValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.StoppableOpenClose;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.TemperatureAndHumidityValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.TemperatureValue;
import pl.grzeslowski.jsupla.protocoljava.api.channels.values.UnknownValue;

public final class ChannelValueSwitch<T> {
    private final Callback<T> callback;

    public ChannelValueSwitch(Callback<T> callback) {
        this.callback = Objects.requireNonNull(callback);
    }

    public T doSwitch(ChannelValue channelValue) {
        if (channelValue instanceof DecimalValue) {
            return this.callback.onDecimalValue((DecimalValue)channelValue);
        }
        if (channelValue instanceof OnOff) {
            return this.callback.onOnOff((OnOff)channelValue);
        }
        if (channelValue instanceof OpenClose) {
            return this.callback.onOpenClose((OpenClose)channelValue);
        }
        if (channelValue instanceof PercentValue) {
            return this.callback.onPercentValue((PercentValue)channelValue);
        }
        if (channelValue instanceof RgbValue) {
            return this.callback.onRgbValue((RgbValue)channelValue);
        }
        if (channelValue instanceof StoppableOpenClose) {
            return this.callback.onStoppableOpenClose((StoppableOpenClose)channelValue);
        }
        if (channelValue instanceof TemperatureAndHumidityValue) {
            return this.callback.onTemperatureAndHumidityValue((TemperatureAndHumidityValue)channelValue);
        }
        if (channelValue instanceof TemperatureValue) {
            return this.callback.onTemperatureValue((TemperatureValue)channelValue);
        }
        if (channelValue instanceof UnknownValue) {
            return this.callback.onUnknownValue((UnknownValue)channelValue);
        }
        throw new IllegalArgumentException(String.format("Don't know where to dispatch channels value with class %s! This should NEVER occur on production!", channelValue.getClass().getSimpleName()));
    }

    public static interface Callback<T> {
        public T onDecimalValue(DecimalValue var1);

        public T onOnOff(OnOff var1);

        public T onOpenClose(OpenClose var1);

        public T onPercentValue(PercentValue var1);

        public T onRgbValue(RgbValue var1);

        public T onStoppableOpenClose(StoppableOpenClose var1);

        public T onTemperatureValue(TemperatureValue var1);

        public T onTemperatureAndHumidityValue(TemperatureAndHumidityValue var1);

        public T onUnknownValue(UnknownValue var1);
    }
}

