import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { getWebFragments } from "/apps/websight-fragments-esm/web-resources/WebFragments.js";
import { errorNotification } from "/apps/websight-rest-atlaskit-client/web-resources/js/Notification.js";
import { AUTH_CONTEXT_UPDATED } from "/apps/websight-rest-atlaskit-client/web-resources/js/RestClient.js";
import NavigationItemsSkeleton from "./NavigationItemsSkeleton.js";
const NAVIGATION_ITEMS_SKELETON_CONFIGS_LOCAL_STORAGE_KEY = 'websight.global-navigation.items.skeleton.configs';
export default class NavigationItemsController extends React.Component {
  constructor(props) {
    super(props);
    const skeletonConfigs = localStorage.getItem(NAVIGATION_ITEMS_SKELETON_CONFIGS_LOCAL_STORAGE_KEY);
    this.state = {
      components: null,
      loadingComponent: /*#__PURE__*/React.createElement(NavigationItemsSkeleton, {
        skeletonConfigs: skeletonConfigs
      })
    };
    this.successHandler = this.successHandler.bind(this);
  }

  componentDidMount() {
    getWebFragments('websight.global.global-navigation.main', this.successHandler, errorNotification);
    window.addEventListener(AUTH_CONTEXT_UPDATED, () => {
      getWebFragments('websight.global.global-navigation.main', this.successHandler, errorNotification);
    });
  }

  successHandler(fragments) {
    if (fragments !== null) {
      const fragmentImports = [];
      const skeletonConfigs = [];
      fragments.forEach(fragment => {
        skeletonConfigs.push(fragment.skeletonConfig);
        fragmentImports.push(import(fragment.menuButtonComponent));
      });
      localStorage.setItem(NAVIGATION_ITEMS_SKELETON_CONFIGS_LOCAL_STORAGE_KEY, JSON.stringify(skeletonConfigs));
      Promise.all(fragmentImports).then(modules => this.getModules(modules.map(module => module.default))).catch(error => errorNotification(error));
    }
  }

  getModules(modules) {
    this.setState({
      components: modules.map((Component, index) => /*#__PURE__*/React.createElement(Component, {
        key: index
      }))
    });
  }

  render() {
    const {
      components,
      loadingComponent
    } = this.state;

    if (components === null) {
      return loadingComponent;
    }

    return components;
  }

}