import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { colors } from "../theme.js";
const TableContainer = styled.div`
    display: block;
    margin: 20px 0 0;
    width: 100%;
`;
const EntryContainer = styled.div`
    margin: 10px 0 0 20px;
`;
const LabelContainer = styled.span`
    display: inline-block;
    color: ${colors.darkGrey};
    padding: 0 5px 0 0;
    width: 100px;
    text-align: right;
    vertical-align: top;
`;
const ValueContainer = styled.div`
    display: inline-block;
`;

const LabelValueTable = props => {
  const {
    data,
    labelWidth,
    skipEmptyValues
  } = props;
  const actualLabelWidth = labelWidth || '100px';
  const actualValueWidth = `calc(100% - ${actualLabelWidth} - 5px)`;
  return /*#__PURE__*/React.createElement(TableContainer, null, data.map(entry => skipEmptyValues && !entry.value ? '' : /*#__PURE__*/React.createElement(EntryContainer, null, /*#__PURE__*/React.createElement(LabelContainer, {
    style: {
      width: actualLabelWidth
    }
  }, entry.label, ":"), /*#__PURE__*/React.createElement(ValueContainer, {
    style: {
      width: actualValueWidth
    }
  }, entry.value))));
};

export default LabelValueTable;