function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import InlineEdit from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/inline-edit.js";
import TextField from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/textfield.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { colors } from "/apps/websight-admin/web-resources/theme.js";
const ReadViewContainer = styled.div`
    border-radius: 3px;
    font-size: 14px;
    height: 28px;
    line-height: 28px;
    max-width: 100%;
    white-space: nowrap;
    overflow: hidden;
    padding: 0 5px;
    text-overflow: ellipsis;
`;
export default class InlineInput extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      value: null,
      prevPropsValue: null
    };
    this.onChange = this.onChange.bind(this);
  }

  static getDerivedStateFromProps(props, state) {
    const {
      value,
      prevPropsValue
    } = state;
    const propsValue = props.value;
    let newValue = {};

    if (propsValue !== value && propsValue !== prevPropsValue) {
      newValue = {
        value: propsValue
      };
    }

    return {
      prevPropsValue: propsValue,
      ...newValue
    };
  }

  onChange(value) {
    this.setState({
      value: value
    }, this.props.onValueChange(value));
  }

  render() {
    return /*#__PURE__*/React.createElement(InlineEdit, {
      readViewFitContainerWidth: true,
      hideActionButtons: true,
      defaultValue: this.props.value,
      editView: fieldProps => /*#__PURE__*/React.createElement(TextField, _extends({}, fieldProps, {
        value: this.state.value,
        autoFocus: true,
        onChange: event => this.onChange(event.target.value),
        isCompact: true
      })),
      readView: () => {
        const readContent = this.props.value ? this.props.value : this.props.placeholder ? /*#__PURE__*/React.createElement("div", {
          style: {
            color: colors.grey
          }
        }, /*#__PURE__*/React.createElement("i", null, this.props.placeholder)) : '';
        return /*#__PURE__*/React.createElement(ReadViewContainer, {
          style: {
            maxWidth: this.props.maxWidth || '100%'
          }
        }, readContent);
      },
      onConfirm: () => {// Do nothing. Changes are handled in TextField component.
      }
    });
  }

}