import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { colors } from "../theme.js";
const OuterContainer = styled.div`
    display: inline-block;
    box-sizing: border-box;
`;
const InnerContainer = styled.span`
    display: flex;
    border-radius: 3px;
    background-color: ${colors.veryLightGrey};
    color: ${colors.veryDarkGrey};
    height: auto;
    margin: 4px 4px;
    padding: 0 4px;
`;
const ContentContainer = styled.span`
    max-width: fit-content;
    white-space: normal;
    font-size: 12px;
    font-weight: normal;
    line-height: 1;
    padding: 3px 2px;
`;

const ContentTag = props => {
  const {
    children
  } = props;
  return /*#__PURE__*/React.createElement(OuterContainer, null, /*#__PURE__*/React.createElement(InnerContainer, null, /*#__PURE__*/React.createElement(ContentContainer, null, children)));
};

export default ContentTag;