function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { LayoutManager, NavigationProvider } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/navigation-next.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { getWebFragments } from "/apps/websight-fragments-esm/web-resources/WebFragments.js";
import { errorNotification } from "/apps/websight-rest-atlaskit-client/web-resources/js/Notification.js";
import GlobalNavigation from "../GlobalNavigation.js";
import MenuItem from "./MenuItem.js";
import { colors } from "../theme.js";
import Footer from "../Footer.js";
const PageContent = styled.div`
    display: block;
    max-width: 980px;
    margin: 0 auto;
    justify-content: center;
    padding: 70px 0;
    background-color: ${colors.veryLightGrey}
`;
const ButtonsContainer = styled.div`
    display: flex;
`;
const Description = styled.div`
    margin: 24px auto 70px auto;
    text-align: center;
    font-size: 22px;
    width: 650px;
`;
const Title = styled.h1`
    text-align: center;
    font-size: 48px;
`;
export default class AdministrationMenu extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      components: null
    };
    getWebFragments('websight.administration.content-navigation.main', fragments => this.setState({
      components: fragments
    }), errorNotification);
  }

  render() {
    const {
      components
    } = this.state;
    return /*#__PURE__*/React.createElement(NavigationProvider, null, /*#__PURE__*/React.createElement(LayoutManager, {
      globalNavigation: GlobalNavigation,
      productNavigation: () => null,
      showContextualNavigation: false,
      experimental_horizontalGlobalNav: true
    }, /*#__PURE__*/React.createElement(PageContent, null, /*#__PURE__*/React.createElement(Title, null, "WebSight.Admin"), /*#__PURE__*/React.createElement(Description, null, "Apache Sling toolset brought to you by Dynamic Solutions,", /*#__PURE__*/React.createElement("br", null), "built to perform your daily tasks in efficient way."), /*#__PURE__*/React.createElement(ButtonsContainer, null, components && components.map((component, index) => /*#__PURE__*/React.createElement(MenuItem, _extends({
      key: index
    }, component))))), /*#__PURE__*/React.createElement(Footer, null)));
  }

}