function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { colors } from "./theme.js";
export const AvatarIcon = props => {
  const iconStyle = {
    color: colors.white,
    background: colors.lightGrey,
    borderRadius: '5px',
    padding: '5px'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const NavigationItemIcon = props => {
  const iconStyle = {
    color: colors.grey
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const FilterPatternIcon = props => {
  const iconStyle = {
    color: colors.darkGrey,
    fontSize: '18px',
    paddingLeft: '6px',
    verticalAlign: 'sub'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const ResourceIcon = props => {
  const {
    style,
    isFolder,
    isExpanded
  } = props;
  const iconStyle = {
    display: 'inline-block',
    cursor: 'pointer',
    fontSize: '18px',
    verticalAlign: 'sub',
    padding: '0 4px 0 0',
    margin: '2px 0'
  };
  let icon = {};

  if (isFolder) {
    isExpanded ? icon = {
      className: 'material-icons-outlined',
      iconName: 'folder_open'
    } : icon = {
      className: 'material-icons-outlined',
      iconName: 'folder'
    };
  } else {
    icon = {
      className: 'material-icons-outlined',
      iconName: 'insert_drive_file'
    };
  }

  return /*#__PURE__*/React.createElement("i", _extends({
    className: icon.className,
    style: { ...iconStyle,
      ...style
    }
  }, props), icon.iconName);
};
export const SelectTagIcon = props => {
  const iconStyle = {
    fontSize: '10px',
    verticalAlign: 'middle',
    paddingRight: '3px'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const TabIcon = props => {
  const iconStyle = {
    fontSize: '20px',
    verticalAlign: 'sub',
    margin: '0 5px 0 0'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const TagIcon = props => {
  const iconStyle = {
    fontSize: '14px',
    padding: '3px 2px 4px 3px',
    verticalAlign: 'middle'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};
export const TreeIcon = props => {
  const iconStyle = {
    cursor: 'pointer',
    fontSize: '18px',
    verticalAlign: 'sub',
    padding: '0 4px 0 0',
    margin: '2px 0'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};