import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { AtlassianNavigation, ProductHome, generateTheme } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/atlassian-navigation.js";
import WebFragments from "/apps/websight-fragments-esm/web-resources/WebFragments.js";
import { errorNotification } from "/apps/websight-rest-atlaskit-client/web-resources/js/Notification.js";
import Logo from "./Logo.js";
import { colors } from "./theme.js";
import NavigationItemsController from "./components/navigation/NavigationItemsController.js";
const theme = generateTheme({
  name: 'high-contrast',
  backgroundColor: colors.darkBlue,
  highlightColor: colors.white // color of outline when using keyboard to navigate

});

const ProfileFragment = () => /*#__PURE__*/React.createElement(WebFragments, {
  fragmentsKey: "websight.administration.global-navigation.profile",
  errorNotification: errorNotification
});

export default class GlobalNavigation extends React.Component {
  render() {
    return /*#__PURE__*/React.createElement(AtlassianNavigation, {
      theme: theme,
      primaryItems: /*#__PURE__*/React.createElement(NavigationItemsController, null),
      renderProductHome: () => /*#__PURE__*/React.createElement(ProductHome, {
        icon: Logo,
        logo: Logo,
        href: "/"
      }),
      renderProfile: ProfileFragment
    });
  }

}