import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import Button from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/button.js";
import TextField from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/textfield.js";
export default class FilePicker extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      fileName: null
    };
  }

  render() {
    return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("input", {
      type: "file",
      name: this.props.name,
      accept: this.props.accept,
      style: {
        display: 'none'
      },
      ref: element => this.inputElement = element,
      onChange: event => {
        const file = event.target.files[0];
        const fileName = file ? file.name : null;
        this.setState({
          fileName: fileName
        });

        if (this.props.onChange) {
          this.props.onChange(event);
        }
      }
    }), /*#__PURE__*/React.createElement(TextField, {
      placeholder: this.props.placeholder || '',
      value: this.props.fileName || this.state.fileName || '',
      isReadOnly: true,
      elemAfterInput: /*#__PURE__*/React.createElement(Button, {
        onClick: () => this.inputElement.click(),
        style: {
          marginRight: '2px'
        }
      }, "Browse")
    }));
  }

}