function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import Button from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/button.js";
import Tooltip from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/tooltip.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { colors } from "./theme.js";
export const TableRowActionButton = props => {
  const iconStyle = {
    fontSize: '16px',
    padding: '8px'
  };
  const icon = /*#__PURE__*/React.createElement("i", {
    className: props.iconClassName || 'material-icons',
    style: iconStyle
  }, props.iconName);
  return /*#__PURE__*/React.createElement(Tooltip, {
    content: props.tooltipContent,
    delay: 0
  }, /*#__PURE__*/React.createElement(Button, _extends({
    iconBefore: icon,
    spacing: "none",
    style: {
      marginRight: '5px'
    }
  }, props)));
};
export const ClearButton = props => {
  const Container = styled.button`
        border: none;
        display: flex;
        background-color: inherit;
        cursor: pointer;
        align-items: center;
        text-align: center;
        padding: 0px;
        border-radius: 50%;
    `;
  const Icon = styled.i`
        color: ${colors.grey}; 
        font-size: 16px;
        padding: 0 4px;

        &:hover {
            color: ${colors.black};
        }
    `;
  return props.isVisible ? /*#__PURE__*/React.createElement(Container, {
    onClick: props.onClick
  }, /*#__PURE__*/React.createElement(Icon, {
    className: "material-icons"
  }, "cancel")) : /*#__PURE__*/React.createElement(React.Fragment, null);
};