import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { Link } from "/apps/websight-atlaskit-esm/web-resources/react-router-dom.js";
import { BreadcrumbsItem, BreadcrumbsStateless } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/breadcrumbs.js";
import { ADMINISTRATION_ROOT_PATH } from "./utils/AdminConstants.js";
const breadcrumbsBase = [{
  text: 'WebSight',
  path: '/',
  reactPath: ''
}, {
  text: 'Administration',
  path: ADMINISTRATION_ROOT_PATH,
  reactPath: ''
}];
/**
 * @param breadcrumbs   Array   Array of objects where each object convert to one breadcrumb item
 *                                  eg. { text: 'Item name', path: '', reactPath: ''}
 */

export default class Breadcrumbs extends React.Component {
  breadcrumbWithReactPath(breadcrumb) {
    return /*#__PURE__*/React.createElement(BreadcrumbsItem, {
      text: breadcrumb.text,
      key: breadcrumb.text,
      href: breadcrumb.reactPath,
      component: ({
        className,
        href,
        children,
        onMouseEnter,
        onMouseLeave
      }) => /*#__PURE__*/React.createElement(Link, {
        className: className,
        to: href,
        onMouseEnter: onMouseEnter,
        onMouseLeave: onMouseLeave
      }, children)
    });
  }

  breadcrumbWithoutReactPath(breadcrumb) {
    return /*#__PURE__*/React.createElement(BreadcrumbsItem, {
      text: breadcrumb.text,
      key: breadcrumb.text,
      href: breadcrumb.path
    });
  }

  render() {
    const breadcrumbs = [...breadcrumbsBase, ...this.props.breadcrumbs];
    return /*#__PURE__*/React.createElement(BreadcrumbsStateless, null, breadcrumbs.map(breadcrumb => breadcrumb.reactPath ? this.breadcrumbWithReactPath(breadcrumb) : this.breadcrumbWithoutReactPath(breadcrumb)));
  }

}