package pl.codewise.commons.aws.cqrs.utils;

import java.util.List;
import java.util.function.Function;

public class Functions {

    public static <S, T> T overrideIfNotNull(S template, S source, Function<S, T> attribute) {
        T override = attribute.apply(template);
        return override != null ? override : attribute.apply(source);
    }

    public static <S, T> List<T> overrideIfNotEmpty(S template, S source, Function<S, List<T>> attribute) {
        List<T> override = attribute.apply(template);
        return override != null && !override.isEmpty() ? override : attribute.apply(source);
    }
}
