package pl.codewise.commons.aws.cqrs.operations.s3;

import java.util.ArrayList;
import java.util.List;

public class PutResult {

    private final List<String> successfulBuckets = new ArrayList<>();
    private final List<String> failedBuckets = new ArrayList<>();
    private final List<String> errorMessages = new ArrayList<>();

    public void collect(boolean succeeded, String bucketName) {
        collect(succeeded, bucketName, "");
    }

    public void collect(boolean succeeded, String bucketName, String errorMessage) {
        if (succeeded) {
            successfulBuckets.add(bucketName);
        } else {
            failedBuckets.add(bucketName);
            errorMessages.add(errorMessage);
        }
    }

    public List<String> getSuccessfulBuckets() {
        return successfulBuckets;
    }

    public List<String> getFailedBuckets() {
        return failedBuckets;
    }

    public List<String> getErrorMessages() {
        return errorMessages;
    }
}
