package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactDetails;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainRequest;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainResult;

public class Route53DomainsOperations {

    private final AmazonRoute53Domains amazonRoute53Domains;

    public Route53DomainsOperations(
            AmazonRoute53Domains amazonRoute53Domains) {
        this.amazonRoute53Domains = amazonRoute53Domains;
    }

    public void disableDomainAutoRenewal(String domainName) {
        amazonRoute53Domains.disableDomainAutoRenew(new DisableDomainAutoRenewRequest().withDomainName(domainName));
    }

    public AwsRegisterDomainResult registerDomain(AwsRegisterDomainRequest request) {
        RegisterDomainRequest registerDomainRequest = toRegisterDomainRequest(request);
        RegisterDomainResult registerDomainResult = amazonRoute53Domains.registerDomain(registerDomainRequest);
        return toAwsRegisterDomainResult(registerDomainResult);
    }

    private AwsRegisterDomainResult toAwsRegisterDomainResult(RegisterDomainResult result) {
        return new AwsRegisterDomainResult(result.getOperationId());
    }

    private RegisterDomainRequest toRegisterDomainRequest(AwsRegisterDomainRequest request) {
        return new RegisterDomainRequest()
                .withDomainName(request.getDomainName())
                .withAutoRenew(request.isAutoRenew())
                .withDurationInYears(request.getDurationYears())
                .withPrivacyProtectAdminContact(request.isProtectAdminContact())
                .withPrivacyProtectRegistrantContact(request.isProtectRegistrantContact())
                .withPrivacyProtectTechContact(request.isProtectTechContact())
                .withAdminContact(toContactDetail(request.getAdminContact()))
                .withRegistrantContact(toContactDetail(request.getRegistrantContact()))
                .withTechContact(toContactDetail(request.getTechContact()));
    }

    private ContactDetail toContactDetail(AwsContactDetails details) {
        return new ContactDetail()
                .withFirstName(details.getFirstName())
                .withLastName(details.getLastName())
                .withOrganizationName(details.getOrganizationName())
                .withPhoneNumber(details.getPhoneNumber())
                .withContactType(details.getContactType().name())
                .withEmail(details.getEmail())
                .withCountryCode(details.getCountryCode())
                .withCity(details.getCity())
                .withAddressLine1(details.getAddressLine1())
                .withAddressLine2(details.getAddressLine2())
                .withZipCode(details.getZipCode());
    }
}
