package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;

import java.util.Arrays;
import java.util.List;

import static java.util.stream.Collectors.toList;

public class ApplicationLoadBalancingOperations {

    private static final Logger log = LoggerFactory.getLogger(ApplicationLoadBalancingOperations.class);

    private final AmazonElasticLoadBalancing amazonElasticLoadBalancing;

    public ApplicationLoadBalancingOperations(AmazonElasticLoadBalancing amazonElasticLoadBalancing) {
        this.amazonElasticLoadBalancing = amazonElasticLoadBalancing;
    }

    public void deregisterInstances(String targetGroupArn, AwsInstance... instances) {
        amazonElasticLoadBalancing.deregisterTargets(new DeregisterTargetsRequest()
                .withTargetGroupArn(targetGroupArn)
                .withTargets(toTargets(instances)));
    }

    public void registerInstances(String targetGroupArn, AwsInstance... instances) {
        amazonElasticLoadBalancing.registerTargets(new RegisterTargetsRequest()
                .withTargetGroupArn(targetGroupArn)
                .withTargets(toTargets(instances)));
    }

    private List<TargetDescription> toTargets(AwsInstance... instances) {
        return Arrays.stream(instances)
                .map(AwsInstance::getInstanceId)
                .map(id -> new TargetDescription().withId(id))
                .collect(toList());
    }
}
