package pl.codewise.commons.aws.cqrs.model.route53;

import static com.google.common.base.Preconditions.checkNotNull;

public class AwsUpdateHealthCheckRequest {

    private final String healthCheckId;
    private final Integer port;

    public AwsUpdateHealthCheckRequest(String healthCheckId, Integer port) {
        this.healthCheckId = healthCheckId;
        this.port = port;
    }

    public String getHealthCheckId() {
        return healthCheckId;
    }

    public Integer getPort() {
        return port;
    }

    public static class Builder {

        private String healthCheckId;
        private Integer port;

        public Builder setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public AwsUpdateHealthCheckRequest build() {
            checkNotNull(healthCheckId, "HealthCheckId must be set!");
            return new AwsUpdateHealthCheckRequest(healthCheckId, port);
        }
    }
}
