package pl.codewise.commons.aws.cqrs.model.route53;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsHostedZone {

    public enum Type {
        PUBLIC,
        PRIVATE
    }

    private final String id;
    private final String name;
    private final Type type;

    public AwsHostedZone(String id, String name, Type type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public Type getType() {
        return type;
    }

    public static class Builder {

        private String id;
        private String name;
        private Type type;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public AwsHostedZone build() {
            return new AwsHostedZone(id, name, type);
        }
    }
}
