package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.util.Date;

public class AwsDomainRegistrationStatus {

    private final String operationId;
    private final String status;
    private final String message;
    private final String domainName;
    private final String type;
    private final Date submittedDate;

    public AwsDomainRegistrationStatus(String operationId, String status, String message, String domainName,
            String type, Date submittedDate) {
        this.operationId = operationId;
        this.status = status;
        this.message = message;
        this.domainName = domainName;
        this.type = type;
        this.submittedDate = submittedDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsDomainRegistrationStatus that = (AwsDomainRegistrationStatus) o;
        return Objects.equal(operationId, that.operationId) &&
                Objects.equal(status, that.status) &&
                Objects.equal(message, that.message) &&
                Objects.equal(domainName, that.domainName) &&
                Objects.equal(type, that.type) &&
                Objects.equal(submittedDate, that.submittedDate);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(operationId, status, message, domainName, type, submittedDate);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getOperationId() {
        return operationId;
    }

    public String getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    public String getDomainName() {
        return domainName;
    }

    public String getType() {
        return type;
    }

    public Date getSubmittedDate() {
        return submittedDate;
    }
}
