package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsContactDetails {

    private final String firstName;
    private final String lastName;
    private final String organizationName;
    private final String phoneNumber;
    private final AwsContactType contactType;
    private final String email;
    private final String countryCode;
    private final String city;
    private final String addressLine1;
    private final String addressLine2;
    private final String zipCode;

    private AwsContactDetails(String firstName, String lastName, String organizationName,
            String phoneNumber,
            AwsContactType contactType, String email, String countryCode, String city,
            String addressLine1, String addressLine2, String zipCode) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.organizationName = organizationName;
        this.phoneNumber = phoneNumber;
        this.contactType = contactType;
        this.email = email;
        this.countryCode = countryCode;
        this.city = city;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.zipCode = zipCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsContactDetails that = (AwsContactDetails) o;
        return Objects.equal(firstName, that.firstName) &&
                Objects.equal(lastName, that.lastName) &&
                Objects.equal(organizationName, that.organizationName) &&
                Objects.equal(phoneNumber, that.phoneNumber) &&
                contactType == that.contactType &&
                Objects.equal(email, that.email) &&
                Objects.equal(countryCode, that.countryCode) &&
                Objects.equal(city, that.city) &&
                Objects.equal(addressLine1, that.addressLine1) &&
                Objects.equal(addressLine2, that.addressLine2) &&
                Objects.equal(zipCode, that.zipCode);
    }

    @Override
    public int hashCode() {
        return Objects
                .hashCode(firstName, lastName, organizationName, phoneNumber, contactType, email, countryCode, city,
                        addressLine1, addressLine2, zipCode);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public AwsContactType getContactType() {
        return contactType;
    }

    public String getEmail() {
        return email;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public String getCity() {
        return city;
    }

    public String getAddressLine1() {
        return addressLine1;
    }

    public String getAddressLine2() {
        return addressLine2;
    }

    public String getZipCode() {
        return zipCode;
    }

    public static class Builder {

        private String firstName;
        private String lastName;
        private String organizationName;
        private String phoneNumber;
        private AwsContactType contactType;
        private String email;
        private String countryCode;
        private String city;
        private String addressLine1;
        private String addressLine2;
        private String zipCode;

        public Builder withFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder withLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder withOrganizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public Builder withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder withContactType(AwsContactType contactType) {
            this.contactType = contactType;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public Builder withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public Builder withZipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public AwsContactDetails build() {
            return new AwsContactDetails(
                    firstName,
                    lastName,
                    organizationName,
                    phoneNumber,
                    contactType,
                    email,
                    countryCode,
                    city,
                    addressLine1,
                    addressLine2,
                    zipCode);
        }
    }
}
