package pl.codewise.commons.aws.cqrs.model.route53;

import java.time.Instant;
import java.util.Objects;

public class AwsBasicDomain {

    private final String domainName;
    private final boolean autoRenew;
    private final Instant expiry;

    public AwsBasicDomain(String domainName, boolean autoRenew, Instant expiry) {
        this.domainName = domainName;
        this.autoRenew = autoRenew;
        this.expiry = expiry;
    }

    public String getDomainName() {
        return domainName;
    }

    public boolean isAutoRenew() {
        return autoRenew;
    }

    public Instant getExpiry() {
        return expiry;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwsBasicDomain)) {
            return false;
        }
        AwsBasicDomain that = (AwsBasicDomain) o;
        return autoRenew == that.autoRenew &&
                Objects.equals(domainName, that.domainName) &&
                Objects.equals(expiry, that.expiry);
    }

    @Override
    public int hashCode() {

        return Objects.hash(domainName, autoRenew, expiry);
    }
}
