package pl.codewise.commons.aws.cqrs.model.ec2.sg;

import java.util.Objects;

public abstract class InboundRule {

    private final String protocol;
    private final String groupId;
    private final int fromPort;
    private final int toPort;
    private final String source;

    public InboundRule(String protocol, String groupId, int fromPort, int toPort, String source) {
        this.protocol = protocol;
        this.fromPort = fromPort;
        this.groupId = groupId;
        this.toPort = toPort;
        this.source = source;
    }

    public String getProtocol() {
        return protocol;
    }

    public String getGroupId() {
        return groupId;
    }

    public int getFromPort() {
        return fromPort;
    }

    public int getToPort() {
        return toPort;
    }

    public String getSource() {
        return source;
    }

    abstract public void accept(InboundRuleVisitor visitor);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InboundRule that = (InboundRule) o;
        return fromPort == that.fromPort &&
                toPort == that.toPort &&
                Objects.equals(protocol, that.protocol) &&
                Objects.equals(groupId, that.groupId) &&
                Objects.equals(source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(protocol, groupId, fromPort, toPort, source);
    }
}
