package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.Objects;

public class AwsResourceTag {

    private final String key;
    private final String value;

    private AwsResourceTag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public String key() {
        return key;
    }

    public String value() {
        return value;
    }

    public static AwsResourceTag create(String key, String value) {
        return new AwsResourceTag(key, value);
    }

    @Override
    public String toString() {
        return "AwsResourceTag{"
                + "key=" + key + ", "
                + "value=" + value
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsResourceTag that = (AwsResourceTag) o;
        return Objects.equal(key, that.key) &&
                Objects.equal(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(key, value);
    }
}