package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.MoreObjects;

public class AwsLoadBalancerHealthCheckParameters {

    private final String target;
    private final int timeout;
    private final int interval;
    private final int unhealthyThreshold;
    private final int healthyThreshold;

    public AwsLoadBalancerHealthCheckParameters(String target, int timeout, int interval, int unhealthyThreshold,
            int healthyThreshold) {
        this.target = target;
        this.timeout = timeout;
        this.interval = interval;
        this.unhealthyThreshold = unhealthyThreshold;
        this.healthyThreshold = healthyThreshold;
    }

    public String getTarget() {
        return target;
    }

    public int getTimeout() {
        return timeout;
    }

    public int getInterval() {
        return interval;
    }

    public int getUnhealthyThreshold() {
        return unhealthyThreshold;
    }

    public int getHealthyThreshold() {
        return healthyThreshold;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("target", target)
                .add("timeout", timeout)
                .add("interval", interval)
                .add("unhealthyThreshold", unhealthyThreshold)
                .add("healthyThreshold", healthyThreshold)
                .toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private String target;
        private int timeout;
        private int interval;
        private int unhealthyThreshold;
        private int healthyThreshold;

        public Builder withTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withInterval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder withUnhealthyThreshold(int unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public Builder withHealthyThreshold(int healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public AwsLoadBalancerHealthCheckParameters build() {
            return new AwsLoadBalancerHealthCheckParameters(target, timeout, interval, unhealthyThreshold,
                    healthyThreshold);
        }
    }
}
