package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.Objects;

public class AwsInstanceBlockDeviceMapping {

    private final String deviceName;
    private final AwsInstanceEbs ebs;

    private AwsInstanceBlockDeviceMapping(String deviceName, AwsInstanceEbs ebs) {
        this.deviceName = deviceName;
        this.ebs = ebs;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public AwsInstanceEbs getEbs() {
        return ebs;
    }

    public String deviceName() {
        return deviceName;
    }

    public AwsInstanceEbs ebs() {
        return ebs;
    }

    public static AwsInstanceBlockDeviceMapping create(String deviceName, AwsInstanceEbs ebs) {
        return new AwsInstanceBlockDeviceMapping(deviceName, ebs);
    }

    @Override
    public String toString() {
        return "AwsInstanceBlockDeviceMapping{"
                + "deviceName=" + deviceName + ", "
                + "ebs=" + ebs
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsInstanceBlockDeviceMapping that = (AwsInstanceBlockDeviceMapping) o;
        return Objects.equal(deviceName, that.deviceName) &&
                Objects.equal(ebs, that.ebs);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(deviceName, ebs);
    }
}
