package pl.codewise.commons.aws.cqrs.model.ec2;

import java.util.Objects;

public class AwsBlockDeviceMapping {

    private final String virtualName;
    private final String deviceName;
    private final Boolean noDevice;
    private final AwsEbs awsEbs;

    public AwsBlockDeviceMapping(String virtualName, String deviceName, Boolean noDevice, AwsEbs ebs) {
        this.virtualName = virtualName;
        this.deviceName = deviceName;
        this.noDevice = noDevice;
        this.awsEbs = ebs;
    }

    public String getVirtualName() {
        return virtualName;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public Boolean getNoDevice() {
        return noDevice;
    }

    public AwsEbs getEbs() {
        return awsEbs;
    }

    @Override
    public String toString() {
        return "AwsBlockDeviceMapping{" +
                "virtualName='" + virtualName + '\'' +
                ", deviceName='" + deviceName + '\'' +
                ", noDevice=" + noDevice +
                ", awsEbs=" + awsEbs +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsBlockDeviceMapping that = (AwsBlockDeviceMapping) o;
        return Objects.equals(virtualName, that.virtualName) &&
                Objects.equals(deviceName, that.deviceName) &&
                Objects.equals(noDevice, that.noDevice) &&
                Objects.equals(awsEbs, that.awsEbs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(virtualName, deviceName, noDevice, awsEbs);
    }
}
