package pl.codewise.commons.aws.cqrs.model.ec2;

import java.util.Objects;

public class AwsAutoScalingTag {

    private final String resourceId;
    private final String key;
    private final String value;
    private final Boolean propagateAtLaunch;
    private final String resourceType = "auto-scaling-group";

    public AwsAutoScalingTag(String resourceId, String key, String value, Boolean propagateAtLaunch) {
        this.resourceId = resourceId;
        this.key = key;
        this.value = value;
        this.propagateAtLaunch = propagateAtLaunch;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsAutoScalingTag that = (AwsAutoScalingTag) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(key, that.key) &&
                Objects.equals(value, that.value) &&
                Objects.equals(propagateAtLaunch, that.propagateAtLaunch) &&
                Objects.equals(resourceType, that.resourceType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, key, value, propagateAtLaunch, resourceType);
    }

    @Override
    public String toString() {
        return "AwsAutoScalingTag{" +
                "resourceId='" + resourceId + '\'' +
                ", key='" + key + '\'' +
                ", value='" + value + '\'' +
                ", propagateAtLaunch=" + propagateAtLaunch +
                ", resourceType='" + resourceType + '\'' +
                '}';
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public Boolean getPropagateAtLaunch() {
        return propagateAtLaunch;
    }

    public String resourceType() {
        return resourceType;
    }
}
