package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsAddress {

    private final String publicIp;
    private final String region;
    private final String instanceId;
    private final String allocationId;
    private final String privateIp;
    private final String associationId;

    public AwsAddress(String publicIp, String region, String instanceId, String allocationId,
            String privateIp, String associationId) {
        this.publicIp = publicIp;
        this.region = region;
        this.instanceId = instanceId;
        this.allocationId = allocationId;
        this.privateIp = privateIp;
        this.associationId = associationId;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsAddress that = (AwsAddress) o;
        return Objects.equal(publicIp, that.publicIp) &&
                Objects.equal(instanceId, that.instanceId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(publicIp, instanceId);
    }

    public String getPublicIp() {
        return publicIp;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public String getRegion() {
        return region;
    }

    public String getAllocationId() {
        return allocationId;
    }

    public String getPrivateIp() {
        return privateIp;
    }

    public String getAssociationId() {
        return associationId;
    }

    public static class Builder {

        private String publicIp;
        private String region;
        private String instanceId;
        private String allocationId;
        private String privateIp;
        private String associationId;

        public Builder withPublicIp(String address) {
            this.publicIp = address;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withAllocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public Builder withPrivateIp(String privateIp) {
            this.privateIp=privateIp;
            return this;
        }

        public Builder withAssociationId(String associationId) {
            this.associationId=associationId;
            return this;
        }

        public AwsAddress build() {
            return new AwsAddress(publicIp, region, instanceId, allocationId, privateIp, associationId);
        }
    }
}
