package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsPrivateIpAddressAssociation {

    private final String ownerId;

    public AwsPrivateIpAddressAssociation(String ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsPrivateIpAddressAssociation that = (AwsPrivateIpAddressAssociation) o;
        return Objects.equal(ownerId, that.ownerId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(ownerId);
    }

    public String getOwnerId() {
        return ownerId;
    }

    public static class Builder {

        private String ownerId;

        public Builder withOwnerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public AwsPrivateIpAddressAssociation build() {
            return new AwsPrivateIpAddressAssociation(ownerId);
        }
    }
}
