package pl.codewise.commons.aws.cqrs.model;

public class AwsNetworkInterfaceAttachment {

    private final Integer deviceIndex;

    public AwsNetworkInterfaceAttachment(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public Integer getDeviceIndex() {
        return deviceIndex;
    }

    public static class Builder {

        private Integer deviceIndex;

        public Builder withDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public AwsNetworkInterfaceAttachment build() {
            return new AwsNetworkInterfaceAttachment(deviceIndex);
        }
    }
}
