package pl.codewise.commons.aws.cqrs.model;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.util.List;

public class AwsNetworkInterface {

    private final String networkInterfaceId;
    private final List<AwsPrivateIpAddress> privateIpAddresses;
    private final AwsNetworkInterfaceAttachment attachment;

    public AwsNetworkInterface(String networkInterfaceId, List<AwsPrivateIpAddress> privateIpAddresses,
            AwsNetworkInterfaceAttachment attachment) {
        this.networkInterfaceId = networkInterfaceId;
        this.privateIpAddresses = privateIpAddresses;
        this.attachment = attachment;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsNetworkInterface that = (AwsNetworkInterface) o;
        return Objects.equal(networkInterfaceId, that.networkInterfaceId) &&
                Objects.equal(privateIpAddresses, that.privateIpAddresses);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(networkInterfaceId, privateIpAddresses);
    }

    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    public List<AwsPrivateIpAddress> getPrivateIpAddresses() {
        return privateIpAddresses;
    }

    public AwsNetworkInterfaceAttachment getAttachment() {
        return attachment;
    }

    public static class Builder {

        private String networkInterfaceId;
        private List<AwsPrivateIpAddress> privateIpAddresses;
        private AwsNetworkInterfaceAttachment attachment;

        public Builder withNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public Builder withPrivateIpAddresses(List<AwsPrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        public Builder withAttachment(AwsNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public AwsNetworkInterface build() {
            return new AwsNetworkInterface(networkInterfaceId, privateIpAddresses, attachment);
        }
    }
}
