package pl.codewise.commons.aws.cqrs.factories.constructors;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.AmazonRoute53Client;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.AmazonRoute53DomainsClient;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import pl.codewise.commons.aws.cqrs.factories.ClientConstructors;

import java.util.function.Function;
public class AmazonClientConstructors implements ClientConstructors {

    private final AmazonClientConfigurationProvider configurationProvider;

    public AmazonClientConstructors(AmazonClientConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonS3> s3() {
        return awsCredentialsProvider -> new AmazonS3Client(
                awsCredentialsProvider,
                configurationProvider.getS3Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonIdentityManagement> iam() {
        return awsCredentialsProvider -> new AmazonIdentityManagementClient(
                awsCredentialsProvider,
                configurationProvider.getIamConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonEC2> ec2() {
        return awsCredentialsProvider -> new AmazonEC2Client(
                awsCredentialsProvider,
                configurationProvider.getEc2Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonAutoScaling> autoScaling() {
        return awsCredentialsProvider -> new AmazonAutoScalingClient(
                awsCredentialsProvider,
                configurationProvider.getAutoScalingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AWSLambda> awsLambda() {
        return awsCredentialsProvider -> new AWSLambdaClient(
                awsCredentialsProvider,
                configurationProvider.getLambdaConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonElasticLoadBalancing> amazonElasticLoadBalancing() {
        return awsCredentialsProvider -> new com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient(
                awsCredentialsProvider,
                configurationProvider.getElasticLoadBalancingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing>
    applicationLoadBalancing() {
        return awsCredentialsProvider ->
                new com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancingClient(
                        awsCredentialsProvider, configurationProvider.getElasticLoadBalancingConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonCloudWatch> amazonCloudWatch() {
        return awsCredentialsProvider -> new AmazonCloudWatchClient(
                awsCredentialsProvider,
                configurationProvider.getCloudWatchConfiguration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonRoute53> amazonRoute53() {
        return awsCredentialsProvider -> new AmazonRoute53Client(
                awsCredentialsProvider,
                configurationProvider.getRoute53Configuration());
    }

    @Override
    public Function<AWSCredentialsProvider, AmazonRoute53Domains> amazonRoute53Domains() {
        return awsCredentialsProvider -> new AmazonRoute53DomainsClient(
                awsCredentialsProvider,
                configurationProvider.getRoute53DomainsConfiguration());
    }
}
