package pl.codewise.commons.aws;

public class EC2InstanceIpProvider implements IpProvider {

    private static final IpAddressValidator IP_ADDRESS_VALIDATOR = new IpAddressValidator();
    private final AwsEc2Instance awsEc2Instance;

    public EC2InstanceIpProvider(AwsEc2Instance awsEc2Instance) {
        this.awsEc2Instance = awsEc2Instance;
    }

    @Override
    public String getIp() throws IpResolutionException {
        String instanceIp = awsEc2Instance.getInstanceIp();
        if (IP_ADDRESS_VALIDATOR.isValid(instanceIp)) {
            return instanceIp;
        }

        throw new IpResolutionException("Amazon instance resolution failed. Ip resolved to: " + instanceIp);
    }
}
