package pl.codewise.commons.aws;

import com.amazonaws.util.EC2MetadataUtils;
import org.apache.commons.io.IOUtils;

import java.net.URI;

public class AwsEc2Instance {

    private static final String AMAZON_RESOLVE_INSTANCE_ID_URL = "http://169.254.169.254/latest/meta-data/instance-id";
    private static final String AMAZON_RESOLVE_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";

    private static final String AVAILABILITY_ZONE_URL =
            "http://169.254.169.254/latest/meta-data/placement/availability-zone";

    public String getRegion() {
        return EC2MetadataUtils.getEC2InstanceRegion();
    }

    public String getInstanceId() {
        try {
            return IOUtils.toString(new URI(AMAZON_RESOLVE_INSTANCE_ID_URL));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getInstanceIp() {
        try {
            return IOUtils.toString(new URI(AMAZON_RESOLVE_IP_URL));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getAvailabilityZone() {
        try {
            return IOUtils.toString(new URI(AVAILABILITY_ZONE_URL));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
