/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.validationcontext;

import jakarta.validation.ClockProvider;
import jakarta.validation.MessageInterpolator;
import java.time.Duration;
import org.hibernate.validator.internal.engine.ValidatorFactoryScopedContext;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class ValidatorScopedContext {
    private final MessageInterpolator messageInterpolator;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ClockProvider clockProvider;
    private final Duration temporalValidationTolerance;
    private final ScriptEvaluatorFactory scriptEvaluatorFactory;
    private final boolean failFast;
    private final boolean traversableResolverResultCacheEnabled;
    private final Object constraintValidatorPayload;

    public ValidatorScopedContext(ValidatorFactoryScopedContext validatorFactoryScopedContext) {
        this.messageInterpolator = validatorFactoryScopedContext.getMessageInterpolator();
        this.parameterNameProvider = validatorFactoryScopedContext.getParameterNameProvider();
        this.clockProvider = validatorFactoryScopedContext.getClockProvider();
        this.temporalValidationTolerance = validatorFactoryScopedContext.getTemporalValidationTolerance();
        this.scriptEvaluatorFactory = validatorFactoryScopedContext.getScriptEvaluatorFactory();
        this.failFast = validatorFactoryScopedContext.isFailFast();
        this.traversableResolverResultCacheEnabled = validatorFactoryScopedContext.isTraversableResolverResultCacheEnabled();
        this.constraintValidatorPayload = validatorFactoryScopedContext.getConstraintValidatorPayload();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public ExecutableParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    public Duration getTemporalValidationTolerance() {
        return this.temporalValidationTolerance;
    }

    public ScriptEvaluatorFactory getScriptEvaluatorFactory() {
        return this.scriptEvaluatorFactory;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean isTraversableResolverResultCacheEnabled() {
        return this.traversableResolverResultCacheEnabled;
    }

    public Object getConstraintValidatorPayload() {
        return this.constraintValidatorPayload;
    }
}

