/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.properties.javabean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import org.hibernate.validator.internal.properties.javabean.JavaBeanConstructor;
import org.hibernate.validator.internal.properties.javabean.JavaBeanExecutable;
import org.hibernate.validator.internal.properties.javabean.JavaBeanField;
import org.hibernate.validator.internal.properties.javabean.JavaBeanGetter;
import org.hibernate.validator.internal.properties.javabean.JavaBeanMethod;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetMethodFromGetterNameCandidates;
import org.hibernate.validator.spi.properties.ConstrainableExecutable;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;

public class JavaBeanHelper {
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy;

    public JavaBeanHelper(GetterPropertySelectionStrategy getterPropertySelectionStrategy) {
        this.getterPropertySelectionStrategy = getterPropertySelectionStrategy;
    }

    public GetterPropertySelectionStrategy getGetterPropertySelectionStrategy() {
        return this.getterPropertySelectionStrategy;
    }

    public Optional<JavaBeanField> findDeclaredField(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        Field field = this.run(GetDeclaredField.action(declaringClass, property));
        return Optional.ofNullable(field).map(JavaBeanField::new);
    }

    public Optional<JavaBeanGetter> findDeclaredGetter(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        return this.findGetter(declaringClass, property, false);
    }

    public Optional<JavaBeanGetter> findGetter(Class<?> declaringClass, String property) {
        Contracts.assertNotNull(declaringClass, Messages.MESSAGES.classCannotBeNull());
        return this.findGetter(declaringClass, property, true);
    }

    private Optional<JavaBeanGetter> findGetter(Class<?> declaringClass, String property, boolean lookForMethodsOnSuperClass) {
        Method getter = this.run(GetMethodFromGetterNameCandidates.action(declaringClass, this.getterPropertySelectionStrategy.getGetterMethodNameCandidates(property), lookForMethodsOnSuperClass));
        if (getter == null) {
            return Optional.empty();
        }
        return Optional.of(new JavaBeanGetter(declaringClass, getter, property));
    }

    public Optional<JavaBeanMethod> findDeclaredMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        Method method = this.run(GetDeclaredMethod.action(declaringClass, methodName, parameterTypes));
        if (method == null) {
            return Optional.empty();
        }
        return Optional.of(this.executable(declaringClass, method));
    }

    public <T> Optional<JavaBeanConstructor> findDeclaredConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        Constructor constructor = (Constructor)this.run(GetDeclaredConstructor.action(declaringClass, parameterTypes));
        if (constructor == null) {
            return Optional.empty();
        }
        return Optional.of(new JavaBeanConstructor(constructor));
    }

    public JavaBeanExecutable<?> executable(Executable executable) {
        return this.executable(executable.getDeclaringClass(), executable);
    }

    public JavaBeanExecutable<?> executable(Class<?> declaringClass, Executable executable) {
        if (executable instanceof Constructor) {
            return new JavaBeanConstructor((Constructor)executable);
        }
        return this.executable(declaringClass, (Method)executable);
    }

    public JavaBeanMethod executable(Class<?> declaringClass, Method method) {
        JavaBeanConstrainableExecutable executable = new JavaBeanConstrainableExecutable(method);
        Optional<String> correspondingProperty = this.getterPropertySelectionStrategy.getProperty(executable);
        if (correspondingProperty.isPresent()) {
            return new JavaBeanGetter(declaringClass, method, correspondingProperty.get());
        }
        return new JavaBeanMethod(method);
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static class JavaBeanConstrainableExecutable
    implements ConstrainableExecutable {
        private final Method method;

        private JavaBeanConstrainableExecutable(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }
    }
}

