/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.ConstraintCreationContext;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.classhierarchy.Filters;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;

public class PredefinedScopeBeanMetaDataManager
implements BeanMetaDataManager {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final BeanMetaDataClassNormalizer beanMetaDataClassNormalizer;
    private final Map<Class<?>, BeanMetaData<?>> beanMetaDataMap;

    public PredefinedScopeBeanMetaDataManager(ConstraintCreationContext constraintCreationContext, ExecutableHelper executableHelper, ExecutableParameterNameProvider parameterNameProvider, JavaBeanHelper javaBeanHelper, ValidationOrderGenerator validationOrderGenerator, List<MetaDataProvider> optionalMetaDataProviders, MethodValidationConfiguration methodValidationConfiguration, BeanMetaDataClassNormalizer beanMetaDataClassNormalizer, Set<Class<?>> beanClassesToInitialize) {
        AnnotationProcessingOptions annotationProcessingOptions = PredefinedScopeBeanMetaDataManager.getAnnotationProcessingOptionsFromNonDefaultProviders(optionalMetaDataProviders);
        AnnotationMetaDataProvider defaultProvider = new AnnotationMetaDataProvider(constraintCreationContext, javaBeanHelper, annotationProcessingOptions);
        ArrayList<MetaDataProvider> metaDataProviders = new ArrayList<MetaDataProvider>(optionalMetaDataProviders.size() + 1);
        metaDataProviders.add(defaultProvider);
        metaDataProviders.addAll(optionalMetaDataProviders);
        HashMap tmpBeanMetadataMap = new HashMap();
        for (Class<?> validatedClass : beanClassesToInitialize) {
            List<Class<?>> classHierarchy = ClassHierarchyHelper.getHierarchy(validatedClass, Filters.excludeInterfaces());
            for (Class<?> hierarchyElement : classHierarchy) {
                tmpBeanMetadataMap.put(beanMetaDataClassNormalizer.normalize(hierarchyElement), PredefinedScopeBeanMetaDataManager.createBeanMetaData(constraintCreationContext, executableHelper, parameterNameProvider, javaBeanHelper, validationOrderGenerator, optionalMetaDataProviders, methodValidationConfiguration, metaDataProviders, hierarchyElement));
            }
        }
        this.beanMetaDataMap = CollectionHelper.toImmutableMap(tmpBeanMetadataMap);
        this.beanMetaDataClassNormalizer = beanMetaDataClassNormalizer;
    }

    @Override
    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        BeanMetaData<?> beanMetaData = this.beanMetaDataMap.get(this.beanMetaDataClassNormalizer.normalize(beanClass));
        if (beanMetaData == null) {
            throw LOG.uninitializedBeanMetaData(beanClass);
        }
        return beanMetaData;
    }

    @Override
    public void clear() {
        this.beanMetaDataMap.clear();
    }

    private static <T> BeanMetaDataImpl<T> createBeanMetaData(ConstraintCreationContext constraintCreationContext, ExecutableHelper executableHelper, ExecutableParameterNameProvider parameterNameProvider, JavaBeanHelper javaBeanHelper, ValidationOrderGenerator validationOrderGenerator, List<MetaDataProvider> optionalMetaDataProviders, MethodValidationConfiguration methodValidationConfiguration, List<MetaDataProvider> metaDataProviders, Class<T> clazz) {
        BeanMetaDataBuilder<T> builder = BeanMetaDataBuilder.getInstance(constraintCreationContext, executableHelper, parameterNameProvider, validationOrderGenerator, clazz, methodValidationConfiguration);
        for (MetaDataProvider provider : metaDataProviders) {
            for (BeanConfiguration<T> beanConfiguration : PredefinedScopeBeanMetaDataManager.getBeanConfigurationForHierarchy(provider, clazz)) {
                builder.add(beanConfiguration);
            }
        }
        return builder.build();
    }

    private static AnnotationProcessingOptions getAnnotationProcessingOptionsFromNonDefaultProviders(List<MetaDataProvider> optionalMetaDataProviders) {
        AnnotationProcessingOptionsImpl options = new AnnotationProcessingOptionsImpl();
        for (MetaDataProvider metaDataProvider : optionalMetaDataProviders) {
            options.merge(metaDataProvider.getAnnotationProcessingOptions());
        }
        return options;
    }

    private static <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(MetaDataProvider provider, Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<T> clazz : ClassHierarchyHelper.getHierarchy(beanClass, new Filter[0])) {
            BeanConfiguration<T> configuration = provider.getBeanConfiguration(clazz);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }
}

