/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.engine.valueextraction.AnnotatedObject;
import org.hibernate.validator.internal.engine.valueextraction.ArrayElement;
import org.hibernate.validator.internal.engine.valueextraction.LegacyCollectionSupportValueExtractors;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ContainerCascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.util.TypeVariables;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class NonContainerCascadingMetaData
implements CascadingMetaData {
    private static final Log LOG = LoggerFactory.make();
    private static final NonContainerCascadingMetaData NON_CASCADING = new NonContainerCascadingMetaData(false, GroupConversionHelper.EMPTY);
    private static final NonContainerCascadingMetaData CASCADING_WITHOUT_GROUP_CONVERSIONS = new NonContainerCascadingMetaData(true, GroupConversionHelper.EMPTY);
    private static final ContainerCascadingMetaData LIST_CONTAINER_WITHOUT_GROUP_CONVERSIONS = new ContainerCascadingMetaData((Type)((Object)List.class), List.class.getTypeParameters()[0], List.class, List.class.getTypeParameters()[0], GroupConversionHelper.EMPTY, LegacyCollectionSupportValueExtractors.LIST);
    private static final ContainerCascadingMetaData MAP_CONTAINER_WITHOUT_GROUP_CONVERSIONS = new ContainerCascadingMetaData((Type)((Object)Map.class), Map.class.getTypeParameters()[1], Map.class, Map.class.getTypeParameters()[1], GroupConversionHelper.EMPTY, LegacyCollectionSupportValueExtractors.MAP);
    private static final ContainerCascadingMetaData ITERABLE_CONTAINER_WITHOUT_GROUP_CONVERSIONS = new ContainerCascadingMetaData((Type)((Object)Iterable.class), Iterable.class.getTypeParameters()[0], Iterable.class, Iterable.class.getTypeParameters()[0], GroupConversionHelper.EMPTY, LegacyCollectionSupportValueExtractors.ITERABLE);
    private static final ContainerCascadingMetaData OPTIONAL_CONTAINER_WITHOUT_GROUP_CONVERSIONS = new ContainerCascadingMetaData((Type)((Object)Optional.class), Optional.class.getTypeParameters()[0], Optional.class, Optional.class.getTypeParameters()[0], GroupConversionHelper.EMPTY, LegacyCollectionSupportValueExtractors.OPTIONAL);
    private final boolean cascading;
    private GroupConversionHelper groupConversionHelper;

    public static NonContainerCascadingMetaData of(CascadingMetaDataBuilder cascadingMetaDataBuilder, Object context) {
        if (!cascadingMetaDataBuilder.isCascading()) {
            return NON_CASCADING;
        }
        if (cascadingMetaDataBuilder.getGroupConversions().isEmpty()) {
            return CASCADING_WITHOUT_GROUP_CONVERSIONS;
        }
        return new NonContainerCascadingMetaData(cascadingMetaDataBuilder);
    }

    private NonContainerCascadingMetaData(CascadingMetaDataBuilder cascadingMetaDataBuilder) {
        this(cascadingMetaDataBuilder.isCascading(), GroupConversionHelper.of(cascadingMetaDataBuilder.getGroupConversions()));
    }

    private NonContainerCascadingMetaData(boolean cascading, GroupConversionHelper groupConversionHelper) {
        this.cascading = cascading;
        this.groupConversionHelper = groupConversionHelper;
    }

    @Override
    public TypeVariable<?> getTypeParameter() {
        return AnnotatedObject.INSTANCE;
    }

    @Override
    public boolean isCascading() {
        return this.cascading;
    }

    @Override
    public boolean isMarkedForCascadingOnAnnotatedObjectOrContainerElements() {
        return this.cascading;
    }

    @Override
    public Class<?> convertGroup(Class<?> originalGroup) {
        return this.groupConversionHelper.convertGroup(originalGroup);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public CascadingMetaData addRuntimeLegacyCollectionSupport(Class<?> valueClass) {
        if (!this.cascading) {
            return this;
        }
        ContainerCascadingMetaData legacyContainerElementCascadingMetaData = this.getLegacyContainerElementCascadingMetaData(valueClass);
        if (legacyContainerElementCascadingMetaData == null) {
            return this;
        }
        return new ContainerCascadingMetaData(valueClass, Collections.singletonList(legacyContainerElementCascadingMetaData), this.groupConversionHelper);
    }

    private ContainerCascadingMetaData getLegacyContainerElementCascadingMetaData(Class<?> valueClass) {
        if (List.class.isAssignableFrom(valueClass)) {
            return this.groupConversionHelper.isEmpty() ? LIST_CONTAINER_WITHOUT_GROUP_CONVERSIONS : new ContainerCascadingMetaData((Type)((Object)List.class), List.class.getTypeParameters()[0], List.class, List.class.getTypeParameters()[0], this.groupConversionHelper, LegacyCollectionSupportValueExtractors.LIST);
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            return this.groupConversionHelper.isEmpty() ? MAP_CONTAINER_WITHOUT_GROUP_CONVERSIONS : new ContainerCascadingMetaData((Type)((Object)Map.class), Map.class.getTypeParameters()[1], Map.class, Map.class.getTypeParameters()[1], this.groupConversionHelper, LegacyCollectionSupportValueExtractors.MAP);
        }
        if (Iterable.class.isAssignableFrom(valueClass)) {
            return this.groupConversionHelper.isEmpty() ? ITERABLE_CONTAINER_WITHOUT_GROUP_CONVERSIONS : new ContainerCascadingMetaData((Type)((Object)Iterable.class), Iterable.class.getTypeParameters()[0], Iterable.class, Iterable.class.getTypeParameters()[0], this.groupConversionHelper, LegacyCollectionSupportValueExtractors.ITERABLE);
        }
        if (Optional.class.isAssignableFrom(valueClass)) {
            return this.groupConversionHelper.isEmpty() ? OPTIONAL_CONTAINER_WITHOUT_GROUP_CONVERSIONS : new ContainerCascadingMetaData((Type)((Object)Optional.class), Optional.class.getTypeParameters()[0], Optional.class, Optional.class.getTypeParameters()[0], this.groupConversionHelper, LegacyCollectionSupportValueExtractors.OPTIONAL);
        }
        if (valueClass.isArray()) {
            ArrayElement typeParameter = new ArrayElement(valueClass);
            return new ContainerCascadingMetaData(valueClass, typeParameter, TypeVariables.getContainerClass(typeParameter), TypeVariables.getActualTypeParameter(typeParameter), this.groupConversionHelper, LegacyCollectionSupportValueExtractors.ARRAY);
        }
        return null;
    }

    @Override
    public <T extends CascadingMetaData> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw LOG.getUnableToCastException(this, clazz);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append("cascading=").append(this.cascading).append(", ");
        sb.append("groupConversions=").append(this.groupConversionHelper).append(", ");
        sb.append("]");
        return sb.toString();
    }
}

