/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.internal.constraintvalidators.hv.ScriptAssertContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.scripting.ScriptEvaluator;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorNotFoundException;

public abstract class AbstractScriptAssertValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    private static final Log log = LoggerFactory.make();
    protected String languageName;
    protected String script;
    protected String escapedScript;
    protected volatile ScriptAssertContext scriptAssertContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptAssertContext getScriptAssertContext(ConstraintValidatorContext constraintValidatorContext) {
        if (this.scriptAssertContext == null) {
            AbstractScriptAssertValidator abstractScriptAssertValidator = this;
            synchronized (abstractScriptAssertValidator) {
                if (this.scriptAssertContext == null) {
                    ScriptEvaluator scriptEvaluator = null;
                    if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
                        try {
                            scriptEvaluator = ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).getScriptEvaluatorForLanguage(this.languageName);
                        }
                        catch (ScriptEvaluatorNotFoundException e) {
                            throw log.getCreationOfScriptExecutorFailedException(this.languageName, (Exception)((Object)e));
                        }
                    }
                    this.scriptAssertContext = new ScriptAssertContext(this.script, scriptEvaluator);
                }
            }
        }
        return this.scriptAssertContext;
    }
}

