/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.strategy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiValuedMap;
import org.hibernate.MappingException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.AssociationInfo;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.strategy.DelegatingStrategy;
import org.hibernate.tool.internal.reveng.strategy.MetaAttributeHelper;
import org.hibernate.tool.internal.reveng.strategy.OverrideBinder;
import org.hibernate.tool.internal.reveng.strategy.SQLTypeMapping;
import org.hibernate.tool.internal.reveng.strategy.TableFilter;
import org.hibernate.tool.internal.util.JdbcToHibernateTypeHelper;
import org.hibernate.tool.internal.util.TableNameQualifier;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OverrideRepository {
    private static final Logger log = Logger.getLogger(OverrideRepository.class);
    private final Map<TypeMappingKey, List<SQLTypeMapping>> typeMappings = new HashMap<TypeMappingKey, List<SQLTypeMapping>>();
    private final List<TableFilter> tableFilters = new ArrayList<TableFilter>();
    private final List<Table> tables = new ArrayList<Table>();
    private final Map<TableIdentifier, List<ForeignKey>> foreignKeys = new HashMap<TableIdentifier, List<ForeignKey>>();
    private final Map<TableColumnKey, String> typeForColumn = new HashMap<TableColumnKey, String>();
    private final Map<TableColumnKey, String> propertyNameForColumn = new HashMap<TableColumnKey, String>();
    private final Map<TableIdentifier, String> identifierStrategyForTable = new HashMap<TableIdentifier, String>();
    private final Map<TableIdentifier, Properties> identifierPropertiesForTable = new HashMap<TableIdentifier, Properties>();
    private final Map<TableIdentifier, List<String>> primaryKeyColumnsForTable = new HashMap<TableIdentifier, List<String>>();
    private final Set<TableColumnKey> excludedColumns;
    private final TableToClassName tableToClassName;
    private final List<RevengStrategy.SchemaSelection> schemaSelections;
    private final Map<TableIdentifier, String> propertyNameForPrimaryKey = new HashMap<TableIdentifier, String>();
    private final Map<TableIdentifier, String> compositeIdNameForTable;
    private final Map<String, String> foreignKeyToOneName;
    private final Map<String, String> foreignKeyToInverseName;
    private final Map<String, Boolean> foreignKeyInverseExclude;
    private final Map<String, Boolean> foreignKeyToOneExclude;
    private final Map<String, AssociationInfo> foreignKeyToEntityInfo;
    private final Map<String, AssociationInfo> foreignKeyToInverseEntityInfo;
    private final Map<TableIdentifier, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>> tableMetaAttributes;
    private final Map<TableColumnKey, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>> columnMetaAttributes;

    public OverrideRepository() {
        this.tableToClassName = new TableToClassName();
        this.excludedColumns = new HashSet<TableColumnKey>();
        this.schemaSelections = new ArrayList<RevengStrategy.SchemaSelection>();
        this.compositeIdNameForTable = new HashMap<TableIdentifier, String>();
        this.foreignKeyToOneName = new HashMap<String, String>();
        this.foreignKeyToInverseName = new HashMap<String, String>();
        this.foreignKeyInverseExclude = new HashMap<String, Boolean>();
        this.foreignKeyToOneExclude = new HashMap<String, Boolean>();
        this.tableMetaAttributes = new HashMap<TableIdentifier, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>>();
        this.columnMetaAttributes = new HashMap<TableColumnKey, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>>();
        this.foreignKeyToEntityInfo = new HashMap<String, AssociationInfo>();
        this.foreignKeyToInverseEntityInfo = new HashMap<String, AssociationInfo>();
    }

    public OverrideRepository addFile(File xmlFile) {
        log.info((Object)("Override file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure overrides from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException("Could not configure overrides from file: " + xmlFile.getPath(), (Throwable)e);
        }
        return this;
    }

    public OverrideRepository addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = OverrideRepository.class.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, (Throwable)me);
        }
    }

    public OverrideRepository addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            final ArrayList errors = new ArrayList();
            ErrorHandler errorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    log.warn((Object)"warning while parsing xml", (Throwable)exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    this.error(exception);
                }
            };
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(errorHandler);
            Document document = db.parse(xmlInputStream);
            if (!errors.isEmpty()) {
                throw new MappingException("invalid override definition", (Throwable)errors.get(0));
            }
            this.add(document);
            OverrideRepository overrideRepository = this;
            return overrideRepository;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.error((Object)"Could not configure overrides from input stream", (Throwable)e);
            throw new MappingException((Throwable)e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
            }
        }
    }

    private OverrideRepository add(Document doc) {
        OverrideBinder.bindRoot(this, doc);
        return this;
    }

    private String getPreferredHibernateType(int sqlType, int length, int precision, int scale, boolean nullable) {
        List<SQLTypeMapping> l = this.typeMappings.get(new TypeMappingKey(sqlType, length));
        if (l == null) {
            l = this.typeMappings.get(new TypeMappingKey(sqlType, Integer.MAX_VALUE));
        }
        return this.scanForMatch(sqlType, length, precision, scale, nullable, l);
    }

    private String scanForMatch(int sqlType, int length, int precision, int scale, boolean nullable, List<SQLTypeMapping> l) {
        if (l != null) {
            for (SQLTypeMapping element : l) {
                if (element.getJDBCType() != sqlType) {
                    return null;
                }
                if (!element.match(sqlType, length, precision, scale, nullable)) continue;
                return element.getHibernateType();
            }
        }
        return null;
    }

    public OverrideRepository addTypeMapping(SQLTypeMapping sqltype) {
        TypeMappingKey key = new TypeMappingKey(sqltype);
        List<SQLTypeMapping> list = this.typeMappings.get(key);
        if (list == null) {
            list = new ArrayList<SQLTypeMapping>();
            this.typeMappings.put(key, list);
        }
        list.add(sqltype);
        return this;
    }

    protected String getPackageName(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            String value = tf.getPackage(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected boolean excludeTable(TableIdentifier identifier) {
        Iterator<TableFilter> iterator = this.tableFilters.iterator();
        boolean hasInclude = false;
        while (iterator.hasNext()) {
            TableFilter tf = iterator.next();
            Boolean value = tf.exclude(identifier);
            if (value != null) {
                return value;
            }
            if (tf.getExclude().booleanValue()) continue;
            hasInclude = true;
        }
        return hasInclude;
    }

    public void addTableFilter(TableFilter filter) {
        this.tableFilters.add(filter);
    }

    public RevengStrategy getReverseEngineeringStrategy(RevengStrategy delegate) {
        return new DelegatingStrategy(delegate){

            @Override
            public boolean excludeTable(TableIdentifier ti) {
                return OverrideRepository.this.excludeTable(ti);
            }

            @Override
            public Map<String, MetaAttribute> tableToMetaAttributes(TableIdentifier tableIdentifier) {
                return OverrideRepository.this.tableToMetaAttributes(tableIdentifier);
            }

            @Override
            public Map<String, MetaAttribute> columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
                return OverrideRepository.this.columnToMetaAttributes(tableIdentifier, column);
            }

            @Override
            public boolean excludeColumn(TableIdentifier identifier, String columnName) {
                return OverrideRepository.this.excludedColumns.contains(new TableColumnKey(identifier, columnName));
            }

            @Override
            public String tableToCompositeIdName(TableIdentifier identifier) {
                String result = OverrideRepository.this.compositeIdNameForTable.get(identifier);
                if (result == null) {
                    return super.tableToCompositeIdName(identifier);
                }
                return result;
            }

            @Override
            public List<RevengStrategy.SchemaSelection> getSchemaSelections() {
                if (OverrideRepository.this.schemaSelections.isEmpty()) {
                    return super.getSchemaSelections();
                }
                return OverrideRepository.this.schemaSelections;
            }

            @Override
            public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
                String result = null;
                Object location = "";
                String info = " t:" + JdbcToHibernateTypeHelper.getJDBCTypeName(sqlType) + " l:" + length + " p:" + precision + " s:" + scale + " n:" + nullable + " id:" + generatedIdentifier;
                location = table != null ? TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName()) + "." + columnName : (String)location + " Column: " + columnName + info;
                if (table != null && columnName != null && (result = OverrideRepository.this.typeForColumn.get(new TableColumnKey(table, columnName))) != null) {
                    log.debug((Object)("explicit column mapping found for [" + (String)location + "] to [" + result + "]"));
                    return result;
                }
                result = OverrideRepository.this.getPreferredHibernateType(sqlType, length, precision, scale, nullable);
                if (result == null) {
                    return super.columnToHibernateTypeName(table, columnName, sqlType, length, precision, scale, nullable, generatedIdentifier);
                }
                log.debug((Object)("<type-mapping> found for [" + (String)location + info + "] to [" + result + "]"));
                return result;
            }

            @Override
            public String tableToClassName(TableIdentifier tableIdentifier) {
                String className = OverrideRepository.this.tableToClassName.get(tableIdentifier);
                if (className != null) {
                    if (className.indexOf(".") >= 0) {
                        return className;
                    }
                    String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                    if (packageName == null) {
                        return className;
                    }
                    return StringHelper.qualify((String)packageName, (String)className);
                }
                String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                if (packageName == null) {
                    return super.tableToClassName(tableIdentifier);
                }
                String string = super.tableToClassName(tableIdentifier);
                if (string == null) {
                    return null;
                }
                return StringHelper.qualify((String)packageName, (String)StringHelper.unqualify((String)string));
            }

            @Override
            public List<ForeignKey> getForeignKeys(TableIdentifier referencedTable) {
                List<ForeignKey> list = OverrideRepository.this.foreignKeys.get(referencedTable);
                if (list == null) {
                    return super.getForeignKeys(referencedTable);
                }
                return list;
            }

            @Override
            public String columnToPropertyName(TableIdentifier table, String column) {
                String result = OverrideRepository.this.propertyNameForColumn.get(new TableColumnKey(table, column));
                if (result == null) {
                    return super.columnToPropertyName(table, column);
                }
                return result;
            }

            @Override
            public String tableToIdentifierPropertyName(TableIdentifier tableIdentifier) {
                String result = OverrideRepository.this.propertyNameForPrimaryKey.get(tableIdentifier);
                if (result == null) {
                    return super.tableToIdentifierPropertyName(tableIdentifier);
                }
                return result;
            }

            @Override
            public String getTableIdentifierStrategyName(TableIdentifier tableIdentifier) {
                String result = OverrideRepository.this.identifierStrategyForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierStrategyName(tableIdentifier);
                }
                log.debug((Object)("tableIdentifierStrategy for " + tableIdentifier + " -> '" + result + "'"));
                return result;
            }

            @Override
            public Properties getTableIdentifierProperties(TableIdentifier tableIdentifier) {
                Properties result = OverrideRepository.this.identifierPropertiesForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierProperties(tableIdentifier);
                }
                return result;
            }

            @Override
            public List<String> getPrimaryKeyColumnNames(TableIdentifier tableIdentifier) {
                List<String> result = OverrideRepository.this.primaryKeyColumnsForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getPrimaryKeyColumnNames(tableIdentifier);
                }
                return result;
            }

            @Override
            public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List<?> fromColumnNames, TableIdentifier referencedTable, List<?> referencedColumnNames, boolean uniqueReference) {
                String property = OverrideRepository.this.foreignKeyToOneName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToInverseEntityName(String keyname, TableIdentifier fromTable, List<?> fromColumnNames, TableIdentifier referencedTable, List<?> referencedColumnNames, boolean uniqueReference) {
                String property = OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToInverseEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List<?> fromColumns, TableIdentifier referencedTable, List<?> referencedColumns, boolean uniqueReference) {
                String property = OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToCollectionName(keyname, fromTable, fromColumns, referencedTable, referencedColumns, uniqueReference);
                }
                return property;
            }

            @Override
            public boolean excludeForeignKeyAsCollection(String keyname, TableIdentifier fromTable, List<?> fromColumns, TableIdentifier referencedTable, List<?> referencedColumns) {
                Boolean bool = OverrideRepository.this.foreignKeyInverseExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsCollection(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public boolean excludeForeignKeyAsManytoOne(String keyname, TableIdentifier fromTable, List<?> fromColumns, TableIdentifier referencedTable, List<?> referencedColumns) {
                Boolean bool = OverrideRepository.this.foreignKeyToOneExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsManytoOne(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public AssociationInfo foreignKeyToInverseAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = OverrideRepository.this.foreignKeyToInverseEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToInverseAssociationInfo(foreignKey);
            }

            @Override
            public AssociationInfo foreignKeyToAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = OverrideRepository.this.foreignKeyToEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToAssociationInfo(foreignKey);
            }
        };
    }

    protected Map<String, MetaAttribute> columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
        MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> specific = this.columnMetaAttributes.get(new TableColumnKey(tableIdentifier, column));
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        return null;
    }

    protected Map<String, MetaAttribute> tableToMetaAttributes(TableIdentifier identifier) {
        MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> specific = this.tableMetaAttributes.get(identifier);
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> general = this.findGeneralAttributes(identifier);
        if (general != null && !general.isEmpty()) {
            return this.toMetaAttributes(general);
        }
        return null;
    }

    private MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> findGeneralAttributes(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> value = tf.getMetaAttributes(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Map<String, MetaAttribute> toMetaAttributes(MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> mvm) {
        HashMap<String, MetaAttribute> result = new HashMap<String, MetaAttribute>();
        MapIterator iter = mvm.mapIterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Collection values = mvm.get((Object)key);
            result.put(key, MetaAttributeHelper.toRealMetaAttribute(key, values));
        }
        return result;
    }

    public RevengStrategy getReverseEngineeringStrategy() {
        return this.getReverseEngineeringStrategy(null);
    }

    public void addTable(Table table, String wantedClassName) {
        for (ForeignKey fk : table.getForeignKeys().values()) {
            TableIdentifier identifier = TableIdentifier.create(fk.getReferencedTable());
            List<ForeignKey> existing = this.foreignKeys.get(identifier);
            if (existing == null) {
                existing = new ArrayList<ForeignKey>();
                this.foreignKeys.put(identifier, existing);
            }
            existing.add(fk);
        }
        if (StringHelper.isNotEmpty((String)wantedClassName)) {
            String packageName;
            TableIdentifier tableIdentifier = TableIdentifier.create(table);
            Object className = wantedClassName;
            if (!wantedClassName.contains(".") && (packageName = this.getPackageName(tableIdentifier)) != null && !packageName.isBlank()) {
                className = packageName + "." + wantedClassName;
            }
            this.tableToClassName.put(tableIdentifier, (String)className);
        }
        this.tables.add(table);
    }

    public void setTypeNameForColumn(TableIdentifier identifier, String columnName, String type) {
        if (StringHelper.isNotEmpty((String)type)) {
            this.typeForColumn.put(new TableColumnKey(identifier, columnName), type);
        }
    }

    public void setExcludedColumn(TableIdentifier tableIdentifier, String columnName) {
        this.excludedColumns.add(new TableColumnKey(tableIdentifier, columnName));
    }

    public void setPropertyNameForColumn(TableIdentifier identifier, String columnName, String property) {
        if (StringHelper.isNotEmpty((String)property)) {
            this.propertyNameForColumn.put(new TableColumnKey(identifier, columnName), property);
        }
    }

    public void addTableIdentifierStrategy(Table table, String identifierClass, Properties params) {
        if (identifierClass != null) {
            TableIdentifier tid = TableIdentifier.create(table);
            this.identifierStrategyForTable.put(tid, identifierClass);
            this.identifierPropertiesForTable.put(tid, params);
        }
    }

    public void addPrimaryKeyNamesForTable(Table table, List<String> boundColumnNames, String propertyName, String compositeIdName) {
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        if (boundColumnNames != null && !boundColumnNames.isEmpty()) {
            this.primaryKeyColumnsForTable.put(tableIdentifier, boundColumnNames);
        }
        if (StringHelper.isNotEmpty((String)propertyName)) {
            this.propertyNameForPrimaryKey.put(tableIdentifier, propertyName);
        }
        if (StringHelper.isNotEmpty((String)compositeIdName)) {
            this.compositeIdNameForTable.put(tableIdentifier, compositeIdName);
        }
    }

    public void addSchemaSelection(RevengStrategy.SchemaSelection schemaSelection) {
        this.schemaSelections.add(schemaSelection);
    }

    public void addForeignKeyInfo(String constraintName, String toOneProperty, Boolean excludeToOne, String inverseProperty, Boolean excludeInverse, AssociationInfo associationInfo, AssociationInfo inverseAssociationInfo) {
        if (StringHelper.isNotEmpty((String)toOneProperty)) {
            this.foreignKeyToOneName.put(constraintName, toOneProperty);
        }
        if (StringHelper.isNotEmpty((String)inverseProperty)) {
            this.foreignKeyToInverseName.put(constraintName, inverseProperty);
        }
        if (excludeInverse != null) {
            this.foreignKeyInverseExclude.put(constraintName, excludeInverse);
        }
        if (excludeToOne != null) {
            this.foreignKeyToOneExclude.put(constraintName, excludeToOne);
        }
        if (associationInfo != null) {
            this.foreignKeyToEntityInfo.put(constraintName, associationInfo);
        }
        if (inverseAssociationInfo != null) {
            this.foreignKeyToInverseEntityInfo.put(constraintName, inverseAssociationInfo);
        }
    }

    public void addMetaAttributeInfo(Table table, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> map) {
        if (map != null && !map.isEmpty()) {
            this.tableMetaAttributes.put(TableIdentifier.create(table), map);
        }
    }

    public void addMetaAttributeInfo(TableIdentifier tableIdentifier, String name, MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> map) {
        if (map != null && !map.isEmpty()) {
            this.columnMetaAttributes.put(new TableColumnKey(tableIdentifier, name), map);
        }
    }

    private class TableToClassName {
        Map<String, TableMapper> map = new HashMap<String, TableMapper>();

        private TableToClassName() {
        }

        private String get(TableIdentifier tableIdentifier) {
            TableMapper mapper = this.map.get(tableIdentifier.getName());
            if (mapper != null && (mapper.catalog == null || tableIdentifier.getCatalog() == null || mapper.catalog.equals(tableIdentifier.getCatalog())) && (mapper.schema == null || tableIdentifier.getSchema() == null || mapper.schema.equals(tableIdentifier.getSchema()))) {
                if (mapper.packageName.length() == 0) {
                    return mapper.className;
                }
                return mapper.packageName + "." + mapper.className;
            }
            return null;
        }

        private void put(TableIdentifier tableIdentifier, String wantedClassName) {
            TableMapper tableMapper = new TableMapper(tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getName(), wantedClassName);
            this.map.put(tableIdentifier.getName(), tableMapper);
        }
    }

    static class TypeMappingKey {
        int type;
        int length;

        TypeMappingKey(SQLTypeMapping mpa) {
            this.type = mpa.getJDBCType();
            this.length = mpa.getLength();
        }

        public TypeMappingKey(int sqlType, int length) {
            this.type = sqlType;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeMappingKey)) {
                return false;
            }
            TypeMappingKey other = (TypeMappingKey)obj;
            return this.type == other.type && this.length == other.length;
        }

        public int hashCode() {
            return (this.type + this.length) % 17;
        }

        public String toString() {
            return this.getClass() + "(type:" + this.type + ", length:" + this.length + ")";
        }
    }

    static class TableColumnKey {
        private TableIdentifier query;
        private String name;

        TableColumnKey(TableIdentifier query, String name) {
            this.query = query;
            this.name = name;
        }

        public int hashCode() {
            int prime = 29;
            int result = 1;
            result = 29 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 29 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableColumnKey other = (TableColumnKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }
    }

    private class TableMapper {
        String catalog;
        String schema;
        String className;
        String packageName;

        private TableMapper(String catalog, String schema, String name, String wantedClassName) {
            this.catalog = catalog;
            this.schema = schema;
            if (wantedClassName.contains(".")) {
                int nameStartPos = wantedClassName.lastIndexOf(".");
                this.className = wantedClassName.substring(nameStartPos + 1);
                this.packageName = wantedClassName.substring(0, nameStartPos);
            } else {
                this.className = wantedClassName;
                this.packageName = "";
            }
        }
    }
}

