/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.internal.export.lint.Detector;
import org.hibernate.tool.internal.export.lint.IssueCollector;

public abstract class EntityModelDetector
extends Detector {
    @Override
    public void visit(IssueCollector collector) {
        for (PersistentClass clazz : this.getMetadata().getEntityBindings()) {
            this.visit(clazz, collector);
        }
    }

    protected void visit(PersistentClass clazz, IssueCollector collector) {
        this.visitProperties(clazz, collector);
    }

    private void visitProperties(PersistentClass clazz, IssueCollector collector) {
        if (clazz.hasIdentifierProperty()) {
            this.visitProperty(clazz, clazz.getIdentifierProperty(), collector);
        }
        for (Property property : clazz.getProperties()) {
            this.visitProperty(clazz, property, collector);
        }
    }

    protected abstract void visitProperty(PersistentClass var1, Property var2, IssueCollector var3);
}

