/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.hbm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.internal.export.common.GenericExporter;
import org.hibernate.tool.internal.export.common.TemplateProducer;
import org.hibernate.tool.internal.export.hbm.Cfg2HbmTool;
import org.hibernate.tool.internal.export.hbm.HibernateMappingGlobalSettings;
import org.hibernate.tool.internal.export.java.POJOClass;

public class HbmExporter
extends GenericExporter {
    protected HibernateMappingGlobalSettings globalSettings = new HibernateMappingGlobalSettings();

    @Override
    protected void setupContext() {
        super.setupContext();
        this.getTemplateHelper().putInContext("hmgs", this.globalSettings);
    }

    public void setGlobalSettings(HibernateMappingGlobalSettings hgs) {
        this.globalSettings = hgs;
    }

    @Override
    public void doStart() {
        this.exportGeneralSettings();
        super.doStart();
    }

    private void exportGeneralSettings() {
        Metadata md;
        Cfg2HbmTool c2h = this.getCfg2HbmTool();
        if (c2h.isImportData(md = this.getMetadata()) && c2h.isNamedQueries(md) && c2h.isNamedSQLQueries(md) && c2h.isFilterDefinitions(md)) {
            TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
            producer.produce(new HashMap<String, Object>(), "hbm/generalhbm.hbm.ftl", new File(this.getOutputDirectory(), "GeneralHbmSettings.hbm.xml"), this.getTemplateName(), "General Settings");
        }
    }

    protected void init() {
        this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplateName", "hbm/hibernate-mapping.hbm.ftl");
        this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.FilePattern", "{package-name}/{class-name}.hbm.xml");
    }

    public HbmExporter() {
        this.init();
    }

    @Override
    protected String getClassNameForFile(POJOClass element) {
        return StringHelper.unqualify((String)((PersistentClass)element.getDecoratedObject()).getEntityName());
    }

    @Override
    protected String getPackageNameForFile(POJOClass element) {
        return StringHelper.qualifier((String)((PersistentClass)element.getDecoratedObject()).getClassName());
    }

    @Override
    protected void exportComponent(Map<String, Object> additionalContext, POJOClass element) {
    }

    @Override
    public String getName() {
        return "hbm2hbmxml";
    }
}

