/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.ddl;

import java.io.File;
import java.util.EnumSet;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.internal.export.common.AbstractExporter;
import org.hibernate.tool.schema.TargetType;

public class DdlExporter
extends AbstractExporter {
    @Override
    protected void doStart() {
        String outputFileName = this.getProperties().getProperty("org.hibernate.tool.api.export.ExporterConstants.OutputFileName");
        Metadata metadata = this.getMetadata();
        EnumSet<TargetType> targetTypes = EnumSet.noneOf(TargetType.class);
        if (this.getExportToConsole()) {
            targetTypes.add(TargetType.STDOUT);
        }
        if (this.getExportToDatabase()) {
            targetTypes.add(TargetType.DATABASE);
        }
        if (null != outputFileName) {
            targetTypes.add(TargetType.SCRIPT);
        }
        if (this.getSchemaUpdate()) {
            SchemaUpdate update = new SchemaUpdate();
            if (outputFileName == null && this.getDelimiter() == null && this.getHaltOnError() && this.getFormat()) {
                update.execute(targetTypes, metadata);
            } else {
                if (null != outputFileName) {
                    File outputFile = new File(this.getOutputDirectory(), outputFileName);
                    update.setOutputFile(outputFile.getPath());
                    this.log.debug((Object)("delimiter ='" + this.getDelimiter() + "'"));
                    update.setDelimiter(this.getDelimiter());
                    update.setFormat(Boolean.valueOf(this.getFormat()).booleanValue());
                }
                if (this.getHaltOnError()) {
                    update.setHaltOnError(Boolean.valueOf(this.getHaltOnError()).booleanValue());
                }
                update.execute(targetTypes, metadata);
                if (!update.getExceptions().isEmpty()) {
                    int i = 1;
                    for (Throwable element : update.getExceptions()) {
                        this.log.warn((Object)("Error #" + i + ": "), element);
                        ++i;
                    }
                    this.log.error((Object)(i - 1 + " errors occurred while performing Hbm2DDLExporter."));
                    if (this.getHaltOnError()) {
                        throw new RuntimeException("Errors while performing Hbm2DDLExporter");
                    }
                }
            }
        } else {
            SchemaExport export = new SchemaExport();
            if (null != outputFileName) {
                export.setOutputFile(new File(this.getOutputDirectory(), outputFileName).toString());
            }
            if (null != this.getDelimiter()) {
                export.setDelimiter(this.getDelimiter());
            }
            export.setHaltOnError(this.getHaltOnError());
            export.setFormat(this.getFormat());
            if (this.getDrop() && this.getCreate()) {
                export.execute(targetTypes, SchemaExport.Action.BOTH, metadata);
            } else if (this.getDrop()) {
                export.execute(targetTypes, SchemaExport.Action.DROP, metadata);
            } else if (this.getCreate()) {
                export.execute(targetTypes, SchemaExport.Action.CREATE, metadata);
            } else {
                export.execute(targetTypes, SchemaExport.Action.NONE, metadata);
            }
        }
    }

    private boolean getCreate() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.CreateDatabase")) {
            return true;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.CreateDatabase");
    }

    private String getDelimiter() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.Delimiter")) {
            return ";";
        }
        return (String)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.Delimiter");
    }

    private boolean getDrop() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.DropDatabase")) {
            return false;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.DropDatabase");
    }

    private boolean getExportToConsole() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.ExportToConsole")) {
            return true;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.ExportToConsole");
    }

    private boolean getExportToDatabase() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.ExportToDatabase")) {
            return true;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.ExportToDatabase");
    }

    private boolean getFormat() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.Format")) {
            return false;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.Format");
    }

    private boolean getHaltOnError() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.HaltOnError")) {
            return false;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.HaltOnError");
    }

    private boolean getSchemaUpdate() {
        if (!this.getProperties().containsKey("org.hibernate.tool.api.export.ExporterConstants.SchemaUpdate")) {
            return false;
        }
        return (Boolean)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.SchemaUpdate");
    }
}

