/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Value;

public class CollectionSecondPass
extends org.hibernate.cfg.CollectionSecondPass {
    private static final long serialVersionUID = ObjectStreamClass.lookup(CollectionSecondPass.class).getSerialVersionUID();
    private MetadataBuildingContext mdbc;

    public CollectionSecondPass(MetadataBuildingContext mdbc, Collection coll) {
        super(mdbc, coll);
        this.mdbc = mdbc;
    }

    public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        this.bindCollectionSecondPass(this.getCollection(), persistentClasses, this.mdbc, inheritedMetas);
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        Value element = this.getCollection().getElement();
        DependantValue elementDependantValue = null;
        String oldElementForeignKeyName = null;
        if (element instanceof DependantValue) {
            elementDependantValue = (DependantValue)element;
            oldElementForeignKeyName = elementDependantValue.getForeignKeyName();
            elementDependantValue.setForeignKeyName("none");
        }
        KeyValue key = this.getCollection().getKey();
        DependantValue keyDependantValue = null;
        String oldKeyForeignKeyName = null;
        if (key instanceof DependantValue) {
            keyDependantValue = (DependantValue)key;
            oldKeyForeignKeyName = keyDependantValue.getForeignKeyName();
            keyDependantValue.setForeignKeyName("none");
        }
        super.doSecondPass(persistentClasses);
        if (elementDependantValue != null) {
            elementDependantValue.setForeignKeyName(oldElementForeignKeyName);
        }
        if (keyDependantValue != null) {
            keyDependantValue.setForeignKeyName(oldKeyForeignKeyName);
        }
    }

    private void bindCollectionSecondPass(Collection collection, Map<?, ?> persistentClasses, MetadataBuildingContext mdbc, Map<?, ?> inheritedMetas) throws MappingException {
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            PersistentClass persistentClass = mdbc.getMetadataCollector().getEntityBinding(oneToMany.getReferencedEntityName());
            if (persistentClass == null) {
                throw new MappingException("Association " + collection.getRole() + " references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(persistentClass);
        }
    }

    private Collection getCollection() {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("collection");
            field.setAccessible(true);
            return (Collection)field.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

