/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.bytecode.internal.none.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.spi.Managed;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.internal.export.lint.EntityModelDetector;
import org.hibernate.tool.internal.export.lint.Issue;
import org.hibernate.tool.internal.export.lint.IssueCollector;

public class InstrumentationDetector
extends EntityModelDetector {
    private boolean enhanceEnabled;

    @Override
    public String getName() {
        return "instrument";
    }

    @Override
    public void initialize(Metadata metadata) {
        super.initialize(metadata);
        BytecodeProvider bytecodeProvider = Environment.getBytecodeProvider();
        if (bytecodeProvider != null && !(bytecodeProvider instanceof BytecodeProviderImpl)) {
            this.enhanceEnabled = true;
        }
    }

    @Override
    protected void visit(PersistentClass clazz, IssueCollector collector) {
        Class mappedClass;
        try {
            mappedClass = clazz.getMappedClass();
        }
        catch (MappingException me) {
            return;
        }
        if (clazz.isLazy()) {
            try {
                mappedClass.getConstructor(new Class[0]);
            }
            catch (SecurityException me) {
            }
            catch (NoSuchMethodException e) {
                collector.reportIssue(new Issue("LAZY_NO_DEFAULT_CONSTRUCTOR", 50, "lazy='true' set for '" + clazz.getEntityName() + "', but class has no default constructor."));
                return;
            }
        } else if (this.enhanceEnabled) {
            Class<?>[] interfaces = mappedClass.getInterfaces();
            boolean enhanced = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intface = interfaces[i];
                if (!intface.getName().equals(Managed.class.getName())) continue;
                enhanced = true;
            }
            if (this.enhanceEnabled && !enhanced) {
                collector.reportIssue(new Issue("LAZY_NOT_INSTRUMENTED", 100, "'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with javaassist"));
                return;
            }
        }
    }

    @Override
    protected void visitProperty(PersistentClass clazz, Property property, IssueCollector collector) {
    }
}

