/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.internal.export.common.AbstractExporter;
import org.hibernate.tool.internal.export.common.TemplateProducer;
import org.hibernate.tool.internal.export.doc.DocFile;
import org.hibernate.tool.internal.export.doc.DocFileManager;
import org.hibernate.tool.internal.export.doc.DocHelper;
import org.hibernate.tool.internal.export.java.POJOClass;

public class DocExporter
extends AbstractExporter {
    private static final String FILE_CSS_DEFINITION = "doc/doc-style.css";
    private static final String FILE_HIBERNATE_IMAGE = "doc/hibernate_logo.gif";
    private static final String FILE_EXTENDS_IMAGE = "doc/inherit.gif";
    private static final String FILE_INDEX = "doc/index.html";
    private static final String FTL_TABLES_INDEX = "doc/tables/index.ftl";
    private static final String FTL_ENTITIES_INDEX = "doc/entities/index.ftl";
    private static final String FTL_ENTITIES_SUMMARY = "doc/entities/summary.ftl";
    private static final String FTL_ENTITIES_ENTITY = "doc/entities/entity.ftl";
    private static final String FTL_ENTITIES_PACKAGE_LIST = "doc/entities/package-list.ftl";
    private static final String FTL_ENTITIES_ENTITY_LIST = "doc/entities/allEntity-list.ftl";
    private static final String FTL_ENTITIES_PERPACKAGE_ENTITY_LIST = "doc/entities/perPackageEntity-list.ftl";
    private static final String FTL_ENTITIES_PACKAGE_SUMMARY = "doc/entities/package-summary.ftl";
    private static final String FTL_TABLES_SUMMARY = "doc/tables/summary.ftl";
    private static final String FTL_TABLES_TABLE_LIST = "doc/tables/table-list.ftl";
    private static final String FTL_TABLES_PERSCHEMA_TABLE_LIST = "doc/tables/schema-table-list.ftl";
    private static final String FTL_TABLES_SCHEMA_LIST = "doc/tables/schema-list.ftl";
    private static final String FTL_TABLES_SCHEMA_SUMMARY = "doc/tables/schema-summary.ftl";
    private static final String FTL_TABLES_TABLE = "doc/tables/table.ftl";
    private DocHelper docHelper;
    private DocFileManager docFileManager;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");

    @Override
    public void doStart() {
        this.generateCommmonAndAssets();
        boolean graphsGenerated = this.generateDot();
        this.generateTablesIndex();
        this.generateTablesSummary(graphsGenerated);
        this.generateTablesDetails();
        this.generateTablesAllSchemasList();
        this.generateTablesAllTablesList();
        this.generateTablesSchemaTableList();
        this.generateTablesSchemaDetailedInfo();
        this.generateEntitiesIndex();
        this.generatePackageSummary(graphsGenerated);
        this.generateEntitiesDetails();
        this.generateEntitiesAllPackagesList();
        this.generateEntitiesAllEntitiesList();
        this.generateEntitiesPackageEntityList();
        this.generateEntitiesPackageDetailedInfo();
    }

    private boolean generateDot() {
        String cmd = this.getProperties().getProperty("dot.executable");
        boolean ignoreError = Boolean.parseBoolean(this.getProperties().getProperty("dot.ignoreerror", "false"));
        if (StringHelper.isNotEmpty((String)cmd)) {
            try {
                Exporter exporter = ExporterFactory.createExporter(ExporterType.GENERIC);
                exporter.getProperties().putAll((Map<?, ?>)this.getProperties());
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ArtifactCollector", this.getArtifactCollector());
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", this.getMetadataDescriptor());
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", this.getOutputDirectory());
                String[] tp = (String[])exporter.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.TemplatePath");
                if (tp != null) {
                    exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", tp);
                }
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplateName", "dot/entitygraph.dot.ftl");
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.FilePattern", "entities/entitygraph.dot");
                exporter.start();
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplateName", "dot/tablegraph.dot.ftl");
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.FilePattern", "tables/tablegraph.dot");
                exporter.start();
                File entityGraphDot = new File(this.getOutputDirectory(), "entities/entitygraph.dot");
                this.dotToFile(cmd, entityGraphDot.toString(), new File(this.getOutputDirectory(), "entities/entitygraph.png").toString());
                this.dotToFile(cmd, entityGraphDot.toString(), new File(this.getOutputDirectory(), "entities/entitygraph.svg").toString());
                this.dotToFile(cmd, entityGraphDot.toString(), new File(this.getOutputDirectory(), "entities/entitygraph.cmap").toString());
                File tableGraphDot = new File(this.getOutputDirectory(), "tables/tablegraph.dot");
                this.dotToFile(cmd, tableGraphDot.toString(), new File(this.getOutputDirectory(), "tables/tablegraph.png").toString());
                this.dotToFile(cmd, tableGraphDot.toString(), new File(this.getOutputDirectory(), "tables/tablegraph.svg").toString());
                this.dotToFile(cmd, tableGraphDot.toString(), new File(this.getOutputDirectory(), "tables/tablegraph.cmap").toString());
                return true;
            }
            catch (IOException e) {
                if (ignoreError) {
                    this.log.warn((Object)"Skipping entitygraph creation since dot.executable was not found and dot.ignoreerror=false.");
                    return false;
                }
                throw new HibernateException("Problem while generating DOT graph for Configuration (set dot.ignoreerror=false to ignore)", (Throwable)e);
            }
        }
        this.log.info((Object)"Skipping entitygraph creation since dot.executable is empty or not-specified.");
        return false;
    }

    private String escape(String fileName) {
        if (IS_LINUX) {
            return fileName;
        }
        return "\"" + fileName + "\"";
    }

    private void dotToFile(String dotExeFileName, String dotFileName, String outFileName) throws IOException {
        String exeCmd = this.escape(dotExeFileName) + " -T" + this.getFormatForFile(outFileName) + " " + this.escape(dotFileName) + " -o " + this.escape(outFileName);
        Process p = Runtime.getRuntime().exec(exeCmd);
        try {
            int c;
            this.log.debug((Object)("Executing: " + exeCmd));
            InputStream in = p.getErrorStream();
            while ((c = in.read()) != -1) {
                System.out.print((char)c);
            }
            in.close();
            int i = p.waitFor();
            if (i != 0) {
                this.log.error((Object)("Error " + i + " while executing: " + exeCmd));
            }
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while executing: " + exeCmd), (Throwable)ie);
        }
    }

    private String getFormatForFile(String outFileName) {
        int idx = outFileName.lastIndexOf(".");
        if (idx == -1 || idx == outFileName.length() - 1) {
            throw new IllegalArgumentException("Can't determine file name extention for file name " + outFileName);
        }
        return outFileName.substring(idx + 1);
    }

    @Override
    protected void setupContext() {
        if (!this.getProperties().contains("jdk5")) {
            this.getProperties().setProperty("jdk5", "true");
        }
        super.setupContext();
        Metadata metadata = this.getMetadata();
        this.docHelper = new DocHelper(metadata, this.getProperties(), this.getCfg2JavaTool());
        this.docFileManager = new DocFileManager(this.docHelper, this.getOutputDirectory());
        this.getTemplateHelper().putInContext("dochelper", this.docHelper);
        this.getTemplateHelper().putInContext("docFileManager", this.docFileManager);
    }

    public void generateCommmonAndAssets() {
        try {
            DocFile cssStylesDocFile = this.docFileManager.getCssStylesDocFile();
            this.processTemplate(new HashMap<String, Object>(0), FILE_CSS_DEFINITION, cssStylesDocFile.getFile());
            DocFile hibernateLogoDocFile = this.docFileManager.getHibernateImageDocFile();
            DocFileManager.copy(this.getClass().getClassLoader(), FILE_HIBERNATE_IMAGE, hibernateLogoDocFile.getFile());
            DocFile extendsImageDocFile = this.docFileManager.getExtendsImageDocFile();
            DocFileManager.copy(this.getClass().getClassLoader(), FILE_EXTENDS_IMAGE, extendsImageDocFile.getFile());
            DocFile mainIndexDocFile = this.docFileManager.getMainIndexDocFile();
            this.processTemplate(new HashMap<String, Object>(0), FILE_INDEX, mainIndexDocFile.getFile());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while copying files.", ioe);
        }
    }

    public void generateTablesIndex() {
        DocFile docFile = this.docFileManager.getTableIndexDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, FTL_TABLES_INDEX, file);
    }

    public void generateEntitiesIndex() {
        DocFile docFile = this.docFileManager.getClassIndexDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, FTL_ENTITIES_INDEX, file);
    }

    public void generateTablesSummary(boolean graphsGenerated) {
        DocFile docFile = this.docFileManager.getTableSummaryDocFile();
        File file = this.docFileManager.getTableSummaryDocFile().getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("graphsGenerated", graphsGenerated);
        if (graphsGenerated) {
            StringBuffer sb = new StringBuffer();
            String fileName = "tables/tablegraph.cmap";
            this.appendFile(sb, fileName);
            parameters.put("tablegrapharea", sb);
        }
        this.processTemplate(parameters, FTL_TABLES_SUMMARY, file);
    }

    private void appendFile(StringBuffer sb, String fileName) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(new File(this.getOutputDirectory(), fileName)));
            while ((str = in.readLine()) != null) {
                sb.append(str);
                sb.append(System.getProperty("line.separator"));
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void generatePackageSummary(boolean graphsGenerated) {
        DocFile docFile = this.docFileManager.getClassSummaryFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        List<String> list = this.docHelper.getPackages();
        if (list.size() > 0) {
            list.remove(0);
        }
        parameters.put("packageList", list);
        parameters.put("graphsGenerated", graphsGenerated);
        if (graphsGenerated) {
            StringBuffer sb = new StringBuffer();
            String fileName = "entities/entitygraph.cmap";
            this.appendFile(sb, fileName);
            parameters.put("entitygrapharea", sb);
        }
        this.processTemplate(parameters, FTL_ENTITIES_SUMMARY, file);
    }

    public void generateTablesDetails() {
        Metadata metadata = this.getMetadata();
        for (Table table : metadata.collectTableMappings()) {
            DocFile docFile = this.docFileManager.getTableDocFile(table);
            if (docFile == null) continue;
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("table", table);
            this.processTemplate(parameters, FTL_TABLES_TABLE, file);
        }
    }

    public void generateEntitiesDetails() {
        for (POJOClass pcObj : this.docHelper.getClasses()) {
            pcObj.getPropertiesForMinimalConstructor();
            DocFile docFile = this.docFileManager.getEntityDocFile(pcObj);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("class", pcObj);
            this.processTemplate(parameters, FTL_ENTITIES_ENTITY, file);
        }
    }

    public void generateEntitiesAllPackagesList() {
        DocFile docFile = this.docFileManager.getAllPackagesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        List<String> list = this.docHelper.getPackages();
        if (list.size() > 0) {
            list.remove(0);
        }
        parameters.put("packageList", list);
        this.processTemplate(parameters, FTL_ENTITIES_PACKAGE_LIST, file);
    }

    public void generateEntitiesAllEntitiesList() {
        DocFile docFile = this.docFileManager.getAllEntitiesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("classList", this.docHelper.getClasses());
        this.processTemplate(parameters, FTL_ENTITIES_ENTITY_LIST, file);
    }

    public void generateEntitiesPackageEntityList() {
        for (String packageName : this.docHelper.getPackages()) {
            if (packageName.equals("All Entities")) continue;
            DocFile docFile = this.docFileManager.getPackageEntityListDocFile(packageName);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("title", packageName);
            parameters.put("classList", this.docHelper.getClasses(packageName));
            this.processTemplate(parameters, FTL_ENTITIES_PERPACKAGE_ENTITY_LIST, file);
        }
    }

    public void generateEntitiesPackageDetailedInfo() {
        List<String> packageList = this.docHelper.getPackages();
        if (packageList.size() > 0) {
            packageList.remove(0);
        }
        for (String packageName : packageList) {
            DocFile summaryDocFile = this.docFileManager.getPackageSummaryDocFile(packageName);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", summaryDocFile);
            parameters.put("package", packageName);
            parameters.put("classList", this.docHelper.getClasses(packageName));
            this.processTemplate(parameters, FTL_ENTITIES_PACKAGE_SUMMARY, summaryDocFile.getFile());
        }
    }

    public void generateTablesAllSchemasList() {
        DocFile docFile = this.docFileManager.getAllSchemasDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("schemaList", this.docHelper.getSchemas());
        this.processTemplate(parameters, FTL_TABLES_SCHEMA_LIST, file);
    }

    public void generateTablesAllTablesList() {
        DocFile docFile = this.docFileManager.getAllTablesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("tableList", this.docHelper.getTables());
        this.processTemplate(parameters, FTL_TABLES_TABLE_LIST, file);
    }

    public void generateTablesSchemaTableList() {
        for (String schemaName : this.docHelper.getSchemas()) {
            DocFile docFile = this.docFileManager.getSchemaTableListDocFile(schemaName);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("title", schemaName);
            parameters.put("tableList", this.docHelper.getTables(schemaName));
            this.processTemplate(parameters, FTL_TABLES_PERSCHEMA_TABLE_LIST, file);
        }
    }

    public void generateTablesSchemaDetailedInfo() {
        for (String schemaName : this.docHelper.getSchemas()) {
            DocFile summaryDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", summaryDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, FTL_TABLES_SCHEMA_SUMMARY, summaryDocFile.getFile());
            DocFile tableListDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            parameters = new HashMap();
            parameters.put("docFile", tableListDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, FTL_TABLES_SCHEMA_SUMMARY, tableListDocFile.getFile());
        }
    }

    protected void processTemplate(Map<String, Object> parameters, String templateName, File outputFile) {
        TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
        producer.produce(parameters, templateName, outputFile, templateName);
    }

    @Override
    public String getName() {
        return "hbm2doc";
    }
}

