/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.tool.ide.completion.EntityNameReference;

public class SubQuery
implements Comparable<SubQuery> {
    List<Integer> tokenIds = new ArrayList<Integer>();
    List<String> tokenText = new ArrayList<String>();
    int startOffset;
    int endOffset;
    int depth;

    @Override
    public int compareTo(SubQuery s) {
        return this.startOffset - s.startOffset;
    }

    public int getTokenCount() {
        return this.tokenIds.size();
    }

    public int getToken(int i) {
        return this.tokenIds.get(i);
    }

    public String getTokenText(int i) {
        return this.tokenText.get(i);
    }

    public List<EntityNameReference> getEntityNames() {
        boolean afterFrom = false;
        boolean afterJoin = false;
        StringBuffer tableNames = new StringBuffer();
        StringBuffer joins = new StringBuffer();
        int i = 0;
        boolean cont = true;
        int lastToken = -1;
        for (Integer typeInteger : this.tokenIds) {
            int type = typeInteger;
            if (!cont) break;
            if (!(afterFrom || type != 82 && type != 163 && type != 66)) {
                afterFrom = true;
            } else if (afterJoin) {
                switch (type) {
                    case 87: 
                    case 88: 
                    case 134: 
                    case 168: {
                        cont = false;
                        break;
                    }
                    case 93: 
                    case 99: 
                    case 103: 
                    case 135: 
                    case 142: {
                        joins.append(",");
                        break;
                    }
                    case 21: {
                        joins.append(",");
                        break;
                    }
                    case 22: {
                        joins.append(".");
                        break;
                    }
                    case 174: {
                        if (lastToken != 22) {
                            joins.append(" ");
                        }
                        joins.append(this.tokenText.get(i));
                    }
                }
            } else if (afterFrom) {
                switch (type) {
                    case 87: 
                    case 88: 
                    case 134: 
                    case 148: 
                    case 168: {
                        cont = false;
                        break;
                    }
                    case 21: {
                        tableNames.append(",");
                        break;
                    }
                    case 22: {
                        tableNames.append(".");
                        break;
                    }
                    case 174: {
                        if (lastToken != 22) {
                            tableNames.append(" ");
                        }
                        tableNames.append(this.tokenText.get(i));
                        break;
                    }
                    case 99: {
                        tableNames.append(",");
                        afterJoin = true;
                        break;
                    }
                }
            }
            ++i;
            lastToken = type;
        }
        ArrayList<EntityNameReference> tables = new ArrayList<EntityNameReference>();
        this.addEntityReferences(tables, tableNames);
        this.addEntityReferences(tables, joins);
        return tables;
    }

    private void addEntityReferences(List<EntityNameReference> tables, StringBuffer tableNames) {
        StringTokenizer tableTokenizer = new StringTokenizer(tableNames.toString(), ",");
        while (tableTokenizer.hasMoreTokens()) {
            String table = tableTokenizer.nextToken().trim();
            if (table.indexOf(32) == -1 && table.length() > 0) {
                tables.add(new EntityNameReference(table, table));
                continue;
            }
            StringTokenizer aliasTokenizer = new StringTokenizer(table, " ");
            if (aliasTokenizer.countTokens() < 2) continue;
            String type = aliasTokenizer.nextToken().trim();
            String alias = aliasTokenizer.nextToken().trim();
            if (type.length() <= 0 || alias.length() <= 0) continue;
            tables.add(new EntityNameReference(type, alias));
        }
    }
}

