/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import jakarta.persistence.EntityManagerFactory;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.orm.jbt.internal.util.ExtendedConfiguration;
import org.hibernate.tool.orm.jbt.internal.util.HibernateToolsPersistenceProvider;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class JpaConfiguration
extends Configuration
implements ExtendedConfiguration {
    Metadata metadata = null;
    SessionFactory sessionFactory;
    String persistenceUnit;

    public JpaConfiguration(String persistenceUnit, Map<?, ?> properties) {
        this.persistenceUnit = persistenceUnit;
        if (properties != null) {
            this.getProperties().putAll(properties);
        }
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.initialize();
        }
        return this.metadata;
    }

    public SessionFactory buildSessionFactory() {
        if (this.sessionFactory == null) {
            this.initialize();
        }
        return this.sessionFactory;
    }

    public Configuration setProperties(Properties properties) {
        super.setProperties(properties);
        this.metadata = null;
        this.sessionFactory = null;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        super.addProperties(properties);
        this.metadata = null;
        this.sessionFactory = null;
        return this;
    }

    @Override
    public void buildMappings() {
        this.initialize();
    }

    public Configuration addFile(File file) {
        throw new RuntimeException("Method 'addFile' should not be called on instances of " + this.getClass().getName());
    }

    public Configuration addClass(Class pc) {
        throw new RuntimeException("Method 'addClass' should not be called on instances of " + this.getClass().getName());
    }

    public Configuration configure() {
        throw new RuntimeException("Method 'configure' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public Configuration configure(Document document) {
        throw new RuntimeException("Method 'configure' should not be called on instances of " + this.getClass().getName());
    }

    public Configuration configure(File file) {
        throw new RuntimeException("Method 'configure' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        throw new RuntimeException("Method 'setEntityResolver' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void setNamingStrategy(ImplicitNamingStrategy namingStrategy) {
        throw new RuntimeException("Method 'setNamingStrategy' should not be called on instances of " + this.getClass().getName());
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public void setPreferBasicCompositeIds(boolean b) {
        throw new RuntimeException("Method 'setPreferBasicCompositeIds' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void setReverseEngineeringStrategy(RevengStrategy strategy) {
        throw new RuntimeException("Method 'setReverseEngineeringStrategy' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public Iterator<PersistentClass> getClassMappings() {
        return this.getMetadata().getEntityBindings().iterator();
    }

    @Override
    public PersistentClass getClassMapping(String name) {
        return this.getMetadata().getEntityBinding(name);
    }

    @Override
    public Iterator<Table> getTableMappings() {
        return this.getMetadata().collectTableMappings().iterator();
    }

    @Override
    public ImplicitNamingStrategy getNamingStrategy() {
        throw new RuntimeException("Method 'getNamingStrategy' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public EntityResolver getEntityResolver() {
        throw new RuntimeException("Method 'getEntityResolver' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void readFromJDBC() {
        throw new RuntimeException("Method 'readFromJDBC' should not be called on instances of " + this.getClass().getName());
    }

    void initialize() {
        EntityManagerFactoryBuilderImpl entityManagerFactoryBuilder = HibernateToolsPersistenceProvider.createEntityManagerFactoryBuilder(this.persistenceUnit, this.getProperties());
        EntityManagerFactory entityManagerFactory = entityManagerFactoryBuilder.build();
        this.sessionFactory = (SessionFactory)entityManagerFactory;
        this.metadata = entityManagerFactoryBuilder.getMetadata();
        this.getProperties().putAll((Map<?, ?>)entityManagerFactory.getProperties());
    }
}

