/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.util.Iterator;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.api.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PersistentClassWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PropertyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TypeWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ValueWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.ColumnWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.PersistentClassWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.PropertyWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.util.DummyMetadataBuildingContext;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class ValueWrapperFactory {
    public static ValueWrapper createArrayWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Array(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createBagWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Bag(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createListWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new List(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createManyToOneWrapper(TableWrapper tableWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new ManyToOne(DummyMetadataBuildingContext.INSTANCE, (Table)tableWrapper.getWrappedObject()));
    }

    public static ValueWrapper createMapWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Map(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createOneToManyWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new OneToMany(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createOneToOneWrapper(PersistentClassWrapper persistentClassWrapper) {
        PersistentClass pc = (PersistentClass)persistentClassWrapper.getWrappedObject();
        return ValueWrapperFactory.createValueWrapper((Value)new OneToOne(DummyMetadataBuildingContext.INSTANCE, pc.getTable(), pc));
    }

    public static ValueWrapper createPrimitiveArrayWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new PrimitiveArray(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createSetWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Set(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createSimpleValueWrapper() {
        return ValueWrapperFactory.createValueWrapper((Value)new BasicValue(DummyMetadataBuildingContext.INSTANCE));
    }

    public static ValueWrapper createComponentWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Component(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createDependantValueWrapper(TableWrapper tableWrapper, ValueWrapper valueWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new DependantValue(DummyMetadataBuildingContext.INSTANCE, (Table)tableWrapper.getWrappedObject(), (KeyValue)valueWrapper.getWrappedObject()));
    }

    public static ValueWrapper createAnyValueWrapper(TableWrapper tableWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new Any(DummyMetadataBuildingContext.INSTANCE, (Table)tableWrapper.getWrappedObject()));
    }

    public static ValueWrapper createIdentifierBagValueWrapper(PersistentClassWrapper persistentClassWrapper) {
        return ValueWrapperFactory.createValueWrapper((Value)new IdentifierBag(DummyMetadataBuildingContext.INSTANCE, (PersistentClass)persistentClassWrapper.getWrappedObject()));
    }

    public static ValueWrapper createValueWrapper(Value wrappedArrayValue) {
        return new ValueWrapperImpl(wrappedArrayValue);
    }

    private static class ValueWrapperImpl
    extends AbstractWrapper
    implements ValueWrapper {
        private Value value = null;

        private ValueWrapperImpl(Value value) {
            this.value = value;
        }

        public Value getWrappedObject() {
            return this.value;
        }

        @Override
        public boolean isSimpleValue() {
            return this.value.isSimpleValue();
        }

        @Override
        public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public ValueWrapper getCollectionElement() {
            Value v;
            if (this.isCollection() && (v = ((Collection)this.value).getElement()) != null) {
                return ValueWrapperFactory.createValueWrapper(v);
            }
            return null;
        }

        @Override
        public boolean isOneToMany() {
            return OneToMany.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isManyToOne() {
            return ManyToOne.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isOneToOne() {
            return OneToOne.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isMap() {
            return Map.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isComponent() {
            return Component.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isEmbedded() {
            if (this.isComponent()) {
                return ((Component)this.value).isEmbedded();
            }
            return false;
        }

        @Override
        public boolean isToOne() {
            return ToOne.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public TableWrapper getTable() {
            return this.value.getTable() == null ? null : TableWrapperFactory.createTableWrapper(this.value.getTable());
        }

        @Override
        public TypeWrapper getType() {
            return this.value.getType() == null ? null : TypeWrapperFactory.createTypeWrapper(this.value.getType());
        }

        @Override
        public void setElement(ValueWrapper v) {
            if (this.isCollection()) {
                ((Collection)this.value).setElement((Value)v.getWrappedObject());
            }
        }

        @Override
        public void setCollectionTable(TableWrapper table) {
            if (this.isCollection()) {
                Table t = table == null ? null : (Table)table.getWrappedObject();
                ((Collection)this.value).setCollectionTable(t);
            }
        }

        @Override
        public void setTable(TableWrapper table) {
            if (this.isSimpleValue()) {
                Table t = table == null ? null : (Table)table.getWrappedObject();
                ((SimpleValue)this.value).setTable(t);
            }
        }

        @Override
        public boolean isList() {
            return List.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public void setIndex(ValueWrapper v) {
            if (IndexedCollection.class.isAssignableFrom(this.value.getClass())) {
                Value val = v == null ? null : (Value)v.getWrappedObject();
                ((IndexedCollection)this.value).setIndex(val);
            }
        }

        @Override
        public void setTypeName(String s) {
            if (this.isCollection()) {
                ((Collection)this.value).setTypeName(s);
            } else if (this.isSimpleValue()) {
                ((SimpleValue)this.value).setTypeName(s);
            }
        }

        @Override
        public String getComponentClassName() {
            if (this.isComponent()) {
                return ((Component)this.value).getComponentClassName();
            }
            return null;
        }

        @Override
        public Iterator<ColumnWrapper> getColumnIterator() {
            final Iterator iterator = this.value.getSelectables().iterator();
            return new Iterator<ColumnWrapper>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ColumnWrapper next() {
                    return ColumnWrapperFactory.createColumnWrapper((Column)iterator.next());
                }
            };
        }

        @Override
        public boolean isTypeSpecified() {
            if (this.isSimpleValue()) {
                return ((SimpleValue)this.value).isTypeSpecified();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'isTypeSpecified()'.");
        }

        @Override
        public TableWrapper getCollectionTable() {
            if (this.isCollection()) {
                Table t = ((Collection)this.value).getCollectionTable();
                return t == null ? null : TableWrapperFactory.createTableWrapper(t);
            }
            return null;
        }

        @Override
        public ValueWrapper getKey() {
            if (this.isCollection()) {
                KeyValue v = ((Collection)this.value).getKey();
                return v == null ? null : ValueWrapperFactory.createValueWrapper((Value)v);
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getKey()'.");
        }

        @Override
        public ValueWrapper getIndex() {
            if (IndexedCollection.class.isAssignableFrom(this.value.getClass())) {
                Value v = ((IndexedCollection)this.value).getIndex();
                return v == null ? null : ValueWrapperFactory.createValueWrapper(v);
            }
            return null;
        }

        @Override
        public String getElementClassName() {
            if (Array.class.isAssignableFrom(this.value.getClass())) {
                return ((Array)this.value).getElementClassName();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getElementClassName()'.");
        }

        @Override
        public String getTypeName() {
            if (this.isCollection()) {
                return ((Collection)this.value).getTypeName();
            }
            if (this.isSimpleValue()) {
                return ((SimpleValue)this.value).getTypeName();
            }
            return null;
        }

        @Override
        public boolean isDependantValue() {
            return DependantValue.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isAny() {
            return Any.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isSet() {
            return Set.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isPrimitiveArray() {
            return PrimitiveArray.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isArray() {
            return Array.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isIdentifierBag() {
            return IdentifierBag.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public boolean isBag() {
            return Bag.class.isAssignableFrom(this.value.getClass());
        }

        @Override
        public String getReferencedEntityName() {
            if (this.isManyToOne() || this.isOneToOne()) {
                return ((ToOne)this.value).getReferencedEntityName();
            }
            if (this.isOneToMany()) {
                return ((OneToMany)this.value).getReferencedEntityName();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getReferencedEntityName()'.");
        }

        @Override
        public String getEntityName() {
            if (this.isOneToOne()) {
                return ((OneToOne)this.value).getEntityName();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getEntityName()'.");
        }

        @Override
        public Iterator<PropertyWrapper> getPropertyIterator() {
            if (this.isComponent()) {
                final Iterator iterator = ((Component)this.value).getProperties().iterator();
                return new Iterator<PropertyWrapper>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public PropertyWrapper next() {
                        return PropertyWrapperFactory.createPropertyWrapper((Property)iterator.next());
                    }
                };
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getPropertyIterator()'.");
        }

        @Override
        public void addColumn(ColumnWrapper column) {
            if (!this.isSimpleValue() || column == null) {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'addColumn(Column)'.");
            }
            ((SimpleValue)this.value).addColumn((Column)column.getWrappedObject());
        }

        @Override
        public void setTypeParameters(Properties properties) {
            if (this.isCollection()) {
                ((Collection)this.value).setTypeParameters(properties);
            } else if (this.isSimpleValue()) {
                ((SimpleValue)this.value).setTypeParameters(properties);
            } else {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setTypeParameters(Properties)'.");
            }
        }

        @Override
        public String getForeignKeyName() {
            if (this.isSimpleValue()) {
                return ((SimpleValue)this.value).getForeignKeyName();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getForeignKeyName()'.");
        }

        @Override
        public PersistentClassWrapper getOwner() {
            PersistentClass owner = null;
            if (this.isCollection()) {
                owner = ((Collection)this.value).getOwner();
                return owner == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper(owner);
            }
            if (this.isComponent()) {
                owner = ((Component)this.value).getOwner();
                return owner == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper(owner);
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getOwner()'.");
        }

        @Override
        public ValueWrapper getElement() {
            if (this.isCollection()) {
                Value v = ((Collection)this.value).getElement();
                return v == null ? null : ValueWrapperFactory.createValueWrapper(v);
            }
            return null;
        }

        @Override
        public String getParentProperty() {
            if (this.isComponent()) {
                return ((Component)this.value).getParentProperty();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getParentProperty()'.");
        }

        @Override
        public void setElementClassName(String name) {
            if (!this.isArray()) {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setElementClassName(String)'.");
            }
            ((Array)this.value).setElementClassName(name);
        }

        @Override
        public void setKey(ValueWrapper v) {
            if (!this.isCollection()) {
                throw new UnsupportedOperationException("Class '" + v.getClass().getName() + "' does not support 'setKey(KeyValue)'.");
            }
            KeyValue val = v == null ? null : (KeyValue)v.getWrappedObject();
            ((Collection)this.value).setKey(val);
        }

        @Override
        public void setFetchModeJoin() {
            if (!Fetchable.class.isAssignableFrom(this.value.getClass())) {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setFetchModeJoin()'.");
            }
            ((Fetchable)this.value).setFetchMode(FetchMode.JOIN);
        }

        @Override
        public boolean isInverse() {
            if (this.isCollection()) {
                return ((Collection)this.value).isInverse();
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'isInverse()'.");
        }

        @Override
        public PersistentClassWrapper getAssociatedClass() {
            if (this.isOneToMany()) {
                PersistentClass pc = ((OneToMany)this.value).getAssociatedClass();
                return pc == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper(pc);
            }
            throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'getAssociatedClass()'.");
        }

        @Override
        public void setLazy(boolean b) {
            if (Fetchable.class.isAssignableFrom(this.value.getClass())) {
                ((Fetchable)this.value).setLazy(b);
            } else if (this.isAny()) {
                ((Any)this.value).setLazy(b);
            } else {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setLazy(boolean)'.");
            }
        }

        @Override
        public void setRole(String role) {
            if (!this.isCollection()) {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setRole(String)'.");
            }
            ((Collection)this.value).setRole(role);
        }

        @Override
        public void setReferencedEntityName(String name) {
            if (this.isToOne()) {
                ((ToOne)this.value).setReferencedEntityName(name);
            } else if (this.isOneToMany()) {
                ((OneToMany)this.value).setReferencedEntityName(name);
            } else {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setReferencedEntityName(String)'.");
            }
        }

        @Override
        public void setAssociatedClass(PersistentClassWrapper pcw) {
            if (!this.isOneToMany()) {
                throw new UnsupportedOperationException("Class '" + this.value.getClass().getName() + "' does not support 'setAssociatedClass(PersistentClass)'.");
            }
            PersistentClass pc = pcw == null ? null : (PersistentClass)pcw.getWrappedObject();
            ((OneToMany)this.value).setAssociatedClass(pc);
        }
    }
}

