/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.hibernate.tool.orm.jbt.api.wrp.TypeWrapper;
import org.hibernate.tool.orm.jbt.internal.util.PrimitiveHelper;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class TypeWrapperFactory {
    public static TypeWrapper createTypeWrapper(Type wrappedType) {
        return new TypeWrapperImpl(wrappedType);
    }

    private static class TypeWrapperImpl
    extends AbstractWrapper
    implements TypeWrapper {
        private Type type = null;

        private TypeWrapperImpl(Type type) {
            this.type = type;
        }

        public Type getWrappedObject() {
            return this.type;
        }

        @Override
        public String toString(Object object) {
            if (BasicType.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                JavaType javaType = ((BasicType)this.type).getJavaTypeDescriptor();
                if (javaType instanceof CalendarJavaType && object instanceof Calendar) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    return simpleDateFormat.format(((Calendar)object).getTime());
                }
                return javaType.toString(object);
            }
            throw new UnsupportedOperationException("Class '" + this.type.getClass().getName() + "' does not support 'toString(Object)'.");
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public Object fromStringValue(String stringValue) {
            if (BasicType.class.isAssignableFrom(this.type.getClass())) {
                return ((BasicType)this.type).getJavaTypeDescriptor().fromString((CharSequence)stringValue);
            }
            throw new UnsupportedOperationException("Class '" + this.type.getClass().getName() + "' does not support 'fromStringValue(Object)'.");
        }

        @Override
        public boolean isEntityType() {
            return this.type.isEntityType();
        }

        @Override
        public boolean isOneToOne() {
            if (EntityType.class.isAssignableFrom(this.type.getClass())) {
                return ((EntityType)this.type).isOneToOne();
            }
            throw new UnsupportedOperationException("Class '" + this.type.getClass().getName() + "' does not support 'isOneToOne()'.");
        }

        @Override
        public boolean isAnyType() {
            return this.type.isAnyType();
        }

        @Override
        public boolean isComponentType() {
            return this.type.isComponentType();
        }

        @Override
        public boolean isCollectionType() {
            return this.type.isCollectionType();
        }

        @Override
        public String getAssociatedEntityName() {
            if (this.isEntityType()) {
                return ((EntityType)this.type).getAssociatedEntityName();
            }
            return null;
        }

        @Override
        public boolean isIntegerType() {
            return Integer.class.isAssignableFrom(this.type.getReturnedClass());
        }

        @Override
        public boolean isArrayType() {
            if (CollectionType.class.isAssignableFrom(this.type.getClass())) {
                return ((CollectionType)this.type).isArrayType();
            }
            return false;
        }

        @Override
        public boolean isInstanceOfPrimitiveType() {
            if (!BasicType.class.isAssignableFrom(this.type.getClass())) {
                return false;
            }
            return PrimitiveHelper.isPrimitive(((BasicType)this.type).getJavaType());
        }

        @Override
        public Class<?> getPrimitiveClass() {
            if (!this.isInstanceOfPrimitiveType()) {
                throw new UnsupportedOperationException("Class '" + this.type.getClass().getName() + "' does not support 'getPrimitiveClass()'.");
            }
            Class javaType = ((BasicType)this.type).getJavaType();
            if (PrimitiveHelper.isPrimitiveWrapperClass(javaType)) {
                return PrimitiveHelper.getPrimitiveClass(javaType);
            }
            return javaType;
        }

        @Override
        public String getRole() {
            if (!this.isCollectionType()) {
                throw new UnsupportedOperationException("Class '" + this.type.getClass().getName() + "' does not support 'getRole()'.");
            }
            return ((CollectionType)this.type).getRole();
        }

        @Override
        public String getReturnedClassName() {
            return this.type.getReturnedClassName();
        }
    }
}

